% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom.R
\name{bbox_intersect}
\alias{bbox_intersect}
\alias{bbox_union}
\title{Bounding box intersection / union}
\usage{
bbox_intersect(x, as_wkt = FALSE)

bbox_union(x, as_wkt = FALSE)
}
\arguments{
\item{x}{Either a character vector of raster file names, or a list with
each element a bounding box numeric vector (xmin, ymin, xmax, ymax).}

\item{as_wkt}{Logical. \code{TRUE} to return the bounding box as a polygon
in OGC WKT format, or \code{FALSE} to return as a numeric vector.}
}
\value{
The intersection (\code{bbox_intersect()}) or union (\code{bbox_union()})
of inputs.
If \code{as_wkt = FALSE} (the default), a numeric vector of length four
containing xmin, ymin, xmax, ymax. If \code{as_wkt = TRUE}, a character string
of OGC WKT for the bbox as POLYGON.
}
\description{
\code{bbox_intersect()} returns the bounding box intersection, and
\code{bbox_union()} returns the bounding box union, for input of
either raster file names or list of bounding boxes. All of the inputs
must be in the same projected coordinate system.
}
\examples{
bbox_list <-list()

elev_file <- system.file("extdata/storml_elev.tif", package="gdalraster")
ds <- new(GDALRaster, elev_file, read_only=TRUE)
bbox_list[[1]] <- ds$bbox()
ds$close()

b5_file <- system.file("extdata/sr_b5_20200829.tif", package="gdalraster")
ds <- new(GDALRaster, b5_file, read_only=TRUE)
bbox_list[[2]] <- ds$bbox()
ds$close()

bnd <- "POLYGON ((324467.3 5104814.2, 323909.4 5104365.4, 323794.2 
5103455.8, 324970.7 5102885.8, 326420.0 5103595.3, 326389.6 5104747.5, 
325298.1 5104929.4, 325298.1 5104929.4, 324467.3 5104814.2))"
bbox_list[[3]] <- bbox_from_wkt(bnd)

print(bbox_list)
bbox_intersect(bbox_list)
bbox_union(bbox_list)
}
\seealso{
\code{\link[=bbox_from_wkt]{bbox_from_wkt()}}, \code{\link[=bbox_to_wkt]{bbox_to_wkt()}}
}
