% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_eic.R
\name{find_eic}
\alias{find_eic}
\title{Finds EICs}
\usage{
find_eic(data, MOI, tolerance = 5e-04)
}
\arguments{
\item{data}{a \emph{list} object. Data extracted from a cdf file,
ideally the output from extract_data().}

\item{MOI}{a \emph{float} object. The mass (m/z) value of interest.}

\item{tolerance}{a \emph{double} object. The tolerance allowed for the MOI.
Default is 0.0005.}
}
\value{
eic, a \emph{data.frame} object. A data frame of time values,
retention time 1, retention time 2, mass values, intensity values, and mass
defects.
}
\description{
\code{find_eic} calculates the mass defect for each ion, then finds
the specific EICs of interest.
}
\details{
Extracted Ion Chromatogram (EIC) is a plot of intensity at a chosen
m/z value, or range of values, as a function of retention time.
This function finds intensity values at the given mass-to-charge (m/z)
values, MOI, and in a range around MOI given a tolerance. Calculates the mass
defect for each ion, then finds the specific EICs of interest. Returns a data
frame of time values, mass values, intensity values, and mass defects.
}
\examples{
file1 <- system.file("extdata","sample1.cdf",package="gcxgclab")
frame <- extract_data(file1,mod_t=.5)
eic <- find_eic(frame, MOI=92.1397,tolerance=0.005)
plot_eic(eic,dim=1,title='EIC for MOI 92.1397')
plot_eic(eic,dim=2,title='EIC for MOI 92.1397')

}
