% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_dynamic_feeds.R
\name{get_free_bike_status}
\alias{get_free_bike_status}
\title{Save the free_bike_status feed.}
\usage{
get_free_bike_status(city, directory, file = "free_bike_status.rds")
}
\arguments{
\item{city}{A character string or a url to an active gbfs.json feed.}

\item{directory}{The name of an existing folder or folder to be created, where the feed will
will be saved.}

\item{file}{The name of an existing file or new file to be saved. Must end in .rds.}
}
\value{
A .rds object generated from the current free_bike_status feed.
}
\description{
If the specified file does not exist, \code{get_free_bike_status} saves the free_bike_status
feed for a given city as a .rds object. If the specified file does exist, \code{get_free_bike_status}
appends the current free_bike_status feed to the existing file. Go to 
`https://github.com/NABSA/gbfs/blob/master/gbfs.md` to see metadata for this dataset.
}
\examples{
\donttest{get_free_bike_status(city = 
"http://biketownpdx.socialbicycles.com/opendata/free_bike_status.json", directory = tempdir())}
\donttest{get_free_bike_status(city = "Melbourne", directory = tempdir())}
}
