% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flmmdch.R
\name{flmmdch}
\alias{flmmdch}
\title{Calculates all possible subsets and selects those where each included covariate is significant.}
\usage{
flmmdch(y, x, p0 = 0.01, select = TRUE, intercept = TRUE,
  chkintercept = FALSE)
}
\arguments{
\item{y}{The dependent variable}

\item{x}{The covariates}

\item{p0}{Cut-off p-value for significance}

\item{select}{If true use fselect}

\item{intercept}{If true intercept included}

\item{chkintercept}{Include intercept depending on p-value}

}
\value{
nv List of subsets with number of covariates and sum of squared residuals
}
\description{
It select =TRUE it calls fselect which removes all such subsets which are a subset of some other selected subset. The remaining ones are ordered according to the sum of squared residuals
}
\examples{
data(gausscov)
flmmdch(redwine[,12],redwine[,1:11])
}
