/*
This file is part of package gastempt

gastempt is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#include <rstan/rstaninc.hpp>
// Code generated by Stan version 2.15.0

#include <stan/model/model_header.hpp>

namespace model_linexp_gastro_1b_namespace {

using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;

typedef Eigen::Matrix<double,Eigen::Dynamic,1> vector_d;
typedef Eigen::Matrix<double,1,Eigen::Dynamic> row_vector_d;
typedef Eigen::Matrix<double,Eigen::Dynamic,Eigen::Dynamic> matrix_d;

static int current_statement_begin__;

class model_linexp_gastro_1b : public prob_grad {
private:
    double prior_v0;
    int n;
    int n_record;
    vector<int> record;
    vector_d minute;
    vector_d volume;
public:
    model_linexp_gastro_1b(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        typedef boost::ecuyer1988 rng_t;
        rng_t base_rng(0);  // 0 seed default
        ctor_body(context__, base_rng, pstream__);
    }

    template <class RNG>
    model_linexp_gastro_1b(stan::io::var_context& context__,
        RNG& base_rng__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, base_rng__, pstream__);
    }

    template <class RNG>
    void ctor_body(stan::io::var_context& context__,
                   RNG& base_rng__,
                   std::ostream* pstream__) {
        current_statement_begin__ = -1;

        static const char* function__ = "model_linexp_gastro_1b_namespace::model_linexp_gastro_1b";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        // initialize member variables
        context__.validate_dims("data initialization", "prior_v0", "double", context__.to_vec());
        prior_v0 = double(0);
        vals_r__ = context__.vals_r("prior_v0");
        pos__ = 0;
        prior_v0 = vals_r__[pos__++];
        context__.validate_dims("data initialization", "n", "int", context__.to_vec());
        n = int(0);
        vals_i__ = context__.vals_i("n");
        pos__ = 0;
        n = vals_i__[pos__++];
        context__.validate_dims("data initialization", "n_record", "int", context__.to_vec());
        n_record = int(0);
        vals_i__ = context__.vals_i("n_record");
        pos__ = 0;
        n_record = vals_i__[pos__++];
        validate_non_negative_index("record", "n", n);
        context__.validate_dims("data initialization", "record", "int", context__.to_vec(n));
        validate_non_negative_index("record", "n", n);
        record = std::vector<int>(n,int(0));
        vals_i__ = context__.vals_i("record");
        pos__ = 0;
        size_t record_limit_0__ = n;
        for (size_t i_0__ = 0; i_0__ < record_limit_0__; ++i_0__) {
            record[i_0__] = vals_i__[pos__++];
        }
        validate_non_negative_index("minute", "n", n);
        context__.validate_dims("data initialization", "minute", "vector_d", context__.to_vec(n));
        validate_non_negative_index("minute", "n", n);
        minute = vector_d(static_cast<Eigen::VectorXd::Index>(n));
        vals_r__ = context__.vals_r("minute");
        pos__ = 0;
        size_t minute_i_vec_lim__ = n;
        for (size_t i_vec__ = 0; i_vec__ < minute_i_vec_lim__; ++i_vec__) {
            minute[i_vec__] = vals_r__[pos__++];
        }
        validate_non_negative_index("volume", "n", n);
        context__.validate_dims("data initialization", "volume", "vector_d", context__.to_vec(n));
        validate_non_negative_index("volume", "n", n);
        volume = vector_d(static_cast<Eigen::VectorXd::Index>(n));
        vals_r__ = context__.vals_r("volume");
        pos__ = 0;
        size_t volume_i_vec_lim__ = n;
        for (size_t i_vec__ = 0; i_vec__ < volume_i_vec_lim__; ++i_vec__) {
            volume[i_vec__] = vals_r__[pos__++];
        }

        // validate, data variables
        check_greater_or_equal(function__,"n",n,0);
        check_greater_or_equal(function__,"n_record",n_record,0);
        // initialize data variables

        try {
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed data

        // validate, set parameter ranges
        num_params_r__ = 0U;
        param_ranges_i__.clear();
        validate_non_negative_index("v0", "n_record", n_record);
        num_params_r__ += n_record;
        validate_non_negative_index("kappa", "n_record", n_record);
        num_params_r__ += n_record;
        validate_non_negative_index("tempt", "n_record", n_record);
        num_params_r__ += n_record;
        ++num_params_r__;
        ++num_params_r__;
        ++num_params_r__;
    }

    ~model_linexp_gastro_1b() { }


    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        stan::io::writer<double> writer__(params_r__,params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;

        if (!(context__.contains_r("v0")))
            throw std::runtime_error("variable v0 missing");
        vals_r__ = context__.vals_r("v0");
        pos__ = 0U;
        validate_non_negative_index("v0", "n_record", n_record);
        context__.validate_dims("initialization", "v0", "vector_d", context__.to_vec(n_record));
        // generate_declaration v0
        vector_d v0(static_cast<Eigen::VectorXd::Index>(n_record));
        for (int j1__ = 0U; j1__ < n_record; ++j1__)
            v0(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_lb_unconstrain(0,v0);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable v0: ") + e.what());
        }

        if (!(context__.contains_r("kappa")))
            throw std::runtime_error("variable kappa missing");
        vals_r__ = context__.vals_r("kappa");
        pos__ = 0U;
        validate_non_negative_index("kappa", "n_record", n_record);
        context__.validate_dims("initialization", "kappa", "vector_d", context__.to_vec(n_record));
        // generate_declaration kappa
        vector_d kappa(static_cast<Eigen::VectorXd::Index>(n_record));
        for (int j1__ = 0U; j1__ < n_record; ++j1__)
            kappa(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_lb_unconstrain(0,kappa);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable kappa: ") + e.what());
        }

        if (!(context__.contains_r("tempt")))
            throw std::runtime_error("variable tempt missing");
        vals_r__ = context__.vals_r("tempt");
        pos__ = 0U;
        validate_non_negative_index("tempt", "n_record", n_record);
        context__.validate_dims("initialization", "tempt", "vector_d", context__.to_vec(n_record));
        // generate_declaration tempt
        vector_d tempt(static_cast<Eigen::VectorXd::Index>(n_record));
        for (int j1__ = 0U; j1__ < n_record; ++j1__)
            tempt(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_lb_unconstrain(0,tempt);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable tempt: ") + e.what());
        }

        if (!(context__.contains_r("sigma")))
            throw std::runtime_error("variable sigma missing");
        vals_r__ = context__.vals_r("sigma");
        pos__ = 0U;
        context__.validate_dims("initialization", "sigma", "double", context__.to_vec());
        // generate_declaration sigma
        double sigma(0);
        sigma = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0,sigma);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable sigma: ") + e.what());
        }

        if (!(context__.contains_r("mu_kappa")))
            throw std::runtime_error("variable mu_kappa missing");
        vals_r__ = context__.vals_r("mu_kappa");
        pos__ = 0U;
        context__.validate_dims("initialization", "mu_kappa", "double", context__.to_vec());
        // generate_declaration mu_kappa
        double mu_kappa(0);
        mu_kappa = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0,mu_kappa);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable mu_kappa: ") + e.what());
        }

        if (!(context__.contains_r("sigma_kappa")))
            throw std::runtime_error("variable sigma_kappa missing");
        vals_r__ = context__.vals_r("sigma_kappa");
        pos__ = 0U;
        context__.validate_dims("initialization", "sigma_kappa", "double", context__.to_vec());
        // generate_declaration sigma_kappa
        double sigma_kappa(0);
        sigma_kappa = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0,sigma_kappa);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable sigma_kappa: ") + e.what());
        }

        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }

    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }


    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(vector<T__>& params_r__,
                 vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {

        T__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;

        // model parameters
        stan::io::reader<T__> in__(params_r__,params_i__);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  v0;
        (void) v0;  // dummy to suppress unused var warning
        if (jacobian__)
            v0 = in__.vector_lb_constrain(0,n_record,lp__);
        else
            v0 = in__.vector_lb_constrain(0,n_record);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  kappa;
        (void) kappa;  // dummy to suppress unused var warning
        if (jacobian__)
            kappa = in__.vector_lb_constrain(0,n_record,lp__);
        else
            kappa = in__.vector_lb_constrain(0,n_record);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  tempt;
        (void) tempt;  // dummy to suppress unused var warning
        if (jacobian__)
            tempt = in__.vector_lb_constrain(0,n_record,lp__);
        else
            tempt = in__.vector_lb_constrain(0,n_record);

        T__ sigma;
        (void) sigma;  // dummy to suppress unused var warning
        if (jacobian__)
            sigma = in__.scalar_lb_constrain(0,lp__);
        else
            sigma = in__.scalar_lb_constrain(0);

        T__ mu_kappa;
        (void) mu_kappa;  // dummy to suppress unused var warning
        if (jacobian__)
            mu_kappa = in__.scalar_lb_constrain(0,lp__);
        else
            mu_kappa = in__.scalar_lb_constrain(0);

        T__ sigma_kappa;
        (void) sigma_kappa;  // dummy to suppress unused var warning
        if (jacobian__)
            sigma_kappa = in__.scalar_lb_constrain(0,lp__);
        else
            sigma_kappa = in__.scalar_lb_constrain(0);


        // transformed parameters


        try {
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed parameters

        const char* function__ = "validate transformed params";
        (void) function__;  // dummy to suppress unused var warning

        // model body
        try {
            {
                int reci(0);
                (void) reci;  // dummy to suppress unused var warning

                stan::math::fill(reci, std::numeric_limits<int>::min());
                T__ v0r;
                (void) v0r;  // dummy to suppress unused var warning

                stan::math::initialize(v0r, DUMMY_VAR__);
                stan::math::fill(v0r,DUMMY_VAR__);
                T__ kappar;
                (void) kappar;  // dummy to suppress unused var warning

                stan::math::initialize(kappar, DUMMY_VAR__);
                stan::math::fill(kappar,DUMMY_VAR__);
                T__ temptr;
                (void) temptr;  // dummy to suppress unused var warning

                stan::math::initialize(temptr, DUMMY_VAR__);
                stan::math::fill(temptr,DUMMY_VAR__);
                validate_non_negative_index("vol", "n", n);
                vector<T__> vol(n);
                stan::math::initialize(vol, DUMMY_VAR__);
                stan::math::fill(vol,DUMMY_VAR__);


                lp_accum__.add(normal_log<propto__>(mu_kappa, 1.5, 0.5));
                lp_accum__.add(normal_log<propto__>(sigma_kappa, 1, 0.5));
                lp_accum__.add(normal_log<propto__>(v0, prior_v0, 100));
                lp_accum__.add(lognormal_log<propto__>(kappa, mu_kappa, sigma_kappa));
                lp_accum__.add(normal_log<propto__>(tempt, 60, 20));
                lp_accum__.add(gamma_log<propto__>(sigma, 20, 0.5));
                for (int i = 1; i <= n; ++i) {

                    stan::math::assign(reci, get_base1(record,i,"record",1));
                    stan::math::assign(v0r, get_base1(v0,reci,"v0",1));
                    stan::math::assign(kappar, get_base1(kappa,reci,"kappa",1));
                    stan::math::assign(temptr, get_base1(tempt,reci,"tempt",1));
                    stan::math::assign(get_base1_lhs(vol,i,"vol",1), ((v0r * (1 + ((kappar * get_base1(minute,i,"minute",1)) / temptr))) * exp((-(get_base1(minute,i,"minute",1)) / temptr))));
                }
                lp_accum__.add(normal_log<propto__>(volume, vol, sigma));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        lp_accum__.add(lp__);
        return lp_accum__.sum();

    } // log_prob()

    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }


    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("v0");
        names__.push_back("kappa");
        names__.push_back("tempt");
        names__.push_back("sigma");
        names__.push_back("mu_kappa");
        names__.push_back("sigma_kappa");
    }


    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(n_record);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n_record);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n_record);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
    }

    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        vars__.resize(0);
        stan::io::reader<double> in__(params_r__,params_i__);
        static const char* function__ = "model_linexp_gastro_1b_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        vector_d v0 = in__.vector_lb_constrain(0,n_record);
        vector_d kappa = in__.vector_lb_constrain(0,n_record);
        vector_d tempt = in__.vector_lb_constrain(0,n_record);
        double sigma = in__.scalar_lb_constrain(0);
        double mu_kappa = in__.scalar_lb_constrain(0);
        double sigma_kappa = in__.scalar_lb_constrain(0);
        for (int k_0__ = 0; k_0__ < n_record; ++k_0__) {
            vars__.push_back(v0[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < n_record; ++k_0__) {
            vars__.push_back(kappa[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < n_record; ++k_0__) {
            vars__.push_back(tempt[k_0__]);
        }
        vars__.push_back(sigma);
        vars__.push_back(mu_kappa);
        vars__.push_back(sigma_kappa);

        if (!include_tparams__) return;
        // declare and define transformed parameters
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;

        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning



        try {
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed parameters

        // write transformed parameters

        if (!include_gqs__) return;
        // declare and define generated quantities


        try {
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate generated quantities

        // write generated quantities
    }

    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng,params_r_vec,params_i_vec,vars_vec,include_tparams,include_gqs,pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }

    static std::string model_name() {
        return "model_linexp_gastro_1b";
    }


    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= n_record; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "v0" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= n_record; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "kappa" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= n_record; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "tempt" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "sigma";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_kappa";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "sigma_kappa";
        param_names__.push_back(param_name_stream__.str());

        if (!include_gqs__ && !include_tparams__) return;

        if (!include_gqs__) return;
    }


    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= n_record; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "v0" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= n_record; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "kappa" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= n_record; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "tempt" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "sigma";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_kappa";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "sigma_kappa";
        param_names__.push_back(param_name_stream__.str());

        if (!include_gqs__ && !include_tparams__) return;

        if (!include_gqs__) return;
    }

}; // model

}




// Code generated by Stan version 2.15.0

#include <stan/model/model_header.hpp>

namespace model_linexp_gastro_1c_namespace {

using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;

typedef Eigen::Matrix<double,Eigen::Dynamic,1> vector_d;
typedef Eigen::Matrix<double,1,Eigen::Dynamic> row_vector_d;
typedef Eigen::Matrix<double,Eigen::Dynamic,Eigen::Dynamic> matrix_d;

static int current_statement_begin__;

class model_linexp_gastro_1c : public prob_grad {
private:
    double prior_v0;
    int n;
    int n_record;
    vector<int> record;
    vector_d minute;
    vector_d volume;
public:
    model_linexp_gastro_1c(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        typedef boost::ecuyer1988 rng_t;
        rng_t base_rng(0);  // 0 seed default
        ctor_body(context__, base_rng, pstream__);
    }

    template <class RNG>
    model_linexp_gastro_1c(stan::io::var_context& context__,
        RNG& base_rng__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, base_rng__, pstream__);
    }

    template <class RNG>
    void ctor_body(stan::io::var_context& context__,
                   RNG& base_rng__,
                   std::ostream* pstream__) {
        current_statement_begin__ = -1;

        static const char* function__ = "model_linexp_gastro_1c_namespace::model_linexp_gastro_1c";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        // initialize member variables
        context__.validate_dims("data initialization", "prior_v0", "double", context__.to_vec());
        prior_v0 = double(0);
        vals_r__ = context__.vals_r("prior_v0");
        pos__ = 0;
        prior_v0 = vals_r__[pos__++];
        context__.validate_dims("data initialization", "n", "int", context__.to_vec());
        n = int(0);
        vals_i__ = context__.vals_i("n");
        pos__ = 0;
        n = vals_i__[pos__++];
        context__.validate_dims("data initialization", "n_record", "int", context__.to_vec());
        n_record = int(0);
        vals_i__ = context__.vals_i("n_record");
        pos__ = 0;
        n_record = vals_i__[pos__++];
        validate_non_negative_index("record", "n", n);
        context__.validate_dims("data initialization", "record", "int", context__.to_vec(n));
        validate_non_negative_index("record", "n", n);
        record = std::vector<int>(n,int(0));
        vals_i__ = context__.vals_i("record");
        pos__ = 0;
        size_t record_limit_0__ = n;
        for (size_t i_0__ = 0; i_0__ < record_limit_0__; ++i_0__) {
            record[i_0__] = vals_i__[pos__++];
        }
        validate_non_negative_index("minute", "n", n);
        context__.validate_dims("data initialization", "minute", "vector_d", context__.to_vec(n));
        validate_non_negative_index("minute", "n", n);
        minute = vector_d(static_cast<Eigen::VectorXd::Index>(n));
        vals_r__ = context__.vals_r("minute");
        pos__ = 0;
        size_t minute_i_vec_lim__ = n;
        for (size_t i_vec__ = 0; i_vec__ < minute_i_vec_lim__; ++i_vec__) {
            minute[i_vec__] = vals_r__[pos__++];
        }
        validate_non_negative_index("volume", "n", n);
        context__.validate_dims("data initialization", "volume", "vector_d", context__.to_vec(n));
        validate_non_negative_index("volume", "n", n);
        volume = vector_d(static_cast<Eigen::VectorXd::Index>(n));
        vals_r__ = context__.vals_r("volume");
        pos__ = 0;
        size_t volume_i_vec_lim__ = n;
        for (size_t i_vec__ = 0; i_vec__ < volume_i_vec_lim__; ++i_vec__) {
            volume[i_vec__] = vals_r__[pos__++];
        }

        // validate, data variables
        check_greater_or_equal(function__,"n",n,0);
        check_greater_or_equal(function__,"n_record",n_record,0);
        // initialize data variables

        try {
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed data

        // validate, set parameter ranges
        num_params_r__ = 0U;
        param_ranges_i__.clear();
        validate_non_negative_index("v0", "n_record", n_record);
        num_params_r__ += n_record;
        validate_non_negative_index("kappa", "n_record", n_record);
        num_params_r__ += n_record;
        validate_non_negative_index("tempt", "n_record", n_record);
        num_params_r__ += n_record;
        ++num_params_r__;
        ++num_params_r__;
        ++num_params_r__;
    }

    ~model_linexp_gastro_1c() { }


    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        stan::io::writer<double> writer__(params_r__,params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;

        if (!(context__.contains_r("v0")))
            throw std::runtime_error("variable v0 missing");
        vals_r__ = context__.vals_r("v0");
        pos__ = 0U;
        validate_non_negative_index("v0", "n_record", n_record);
        context__.validate_dims("initialization", "v0", "vector_d", context__.to_vec(n_record));
        // generate_declaration v0
        vector_d v0(static_cast<Eigen::VectorXd::Index>(n_record));
        for (int j1__ = 0U; j1__ < n_record; ++j1__)
            v0(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_lb_unconstrain(0,v0);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable v0: ") + e.what());
        }

        if (!(context__.contains_r("kappa")))
            throw std::runtime_error("variable kappa missing");
        vals_r__ = context__.vals_r("kappa");
        pos__ = 0U;
        validate_non_negative_index("kappa", "n_record", n_record);
        context__.validate_dims("initialization", "kappa", "vector_d", context__.to_vec(n_record));
        // generate_declaration kappa
        vector_d kappa(static_cast<Eigen::VectorXd::Index>(n_record));
        for (int j1__ = 0U; j1__ < n_record; ++j1__)
            kappa(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_lb_unconstrain(0,kappa);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable kappa: ") + e.what());
        }

        if (!(context__.contains_r("tempt")))
            throw std::runtime_error("variable tempt missing");
        vals_r__ = context__.vals_r("tempt");
        pos__ = 0U;
        validate_non_negative_index("tempt", "n_record", n_record);
        context__.validate_dims("initialization", "tempt", "vector_d", context__.to_vec(n_record));
        // generate_declaration tempt
        vector_d tempt(static_cast<Eigen::VectorXd::Index>(n_record));
        for (int j1__ = 0U; j1__ < n_record; ++j1__)
            tempt(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_lb_unconstrain(0,tempt);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable tempt: ") + e.what());
        }

        if (!(context__.contains_r("sigma")))
            throw std::runtime_error("variable sigma missing");
        vals_r__ = context__.vals_r("sigma");
        pos__ = 0U;
        context__.validate_dims("initialization", "sigma", "double", context__.to_vec());
        // generate_declaration sigma
        double sigma(0);
        sigma = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0,sigma);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable sigma: ") + e.what());
        }

        if (!(context__.contains_r("mu_kappa")))
            throw std::runtime_error("variable mu_kappa missing");
        vals_r__ = context__.vals_r("mu_kappa");
        pos__ = 0U;
        context__.validate_dims("initialization", "mu_kappa", "double", context__.to_vec());
        // generate_declaration mu_kappa
        double mu_kappa(0);
        mu_kappa = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0,mu_kappa);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable mu_kappa: ") + e.what());
        }

        if (!(context__.contains_r("sigma_kappa")))
            throw std::runtime_error("variable sigma_kappa missing");
        vals_r__ = context__.vals_r("sigma_kappa");
        pos__ = 0U;
        context__.validate_dims("initialization", "sigma_kappa", "double", context__.to_vec());
        // generate_declaration sigma_kappa
        double sigma_kappa(0);
        sigma_kappa = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0,sigma_kappa);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable sigma_kappa: ") + e.what());
        }

        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }

    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }


    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(vector<T__>& params_r__,
                 vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {

        T__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;

        // model parameters
        stan::io::reader<T__> in__(params_r__,params_i__);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  v0;
        (void) v0;  // dummy to suppress unused var warning
        if (jacobian__)
            v0 = in__.vector_lb_constrain(0,n_record,lp__);
        else
            v0 = in__.vector_lb_constrain(0,n_record);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  kappa;
        (void) kappa;  // dummy to suppress unused var warning
        if (jacobian__)
            kappa = in__.vector_lb_constrain(0,n_record,lp__);
        else
            kappa = in__.vector_lb_constrain(0,n_record);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  tempt;
        (void) tempt;  // dummy to suppress unused var warning
        if (jacobian__)
            tempt = in__.vector_lb_constrain(0,n_record,lp__);
        else
            tempt = in__.vector_lb_constrain(0,n_record);

        T__ sigma;
        (void) sigma;  // dummy to suppress unused var warning
        if (jacobian__)
            sigma = in__.scalar_lb_constrain(0,lp__);
        else
            sigma = in__.scalar_lb_constrain(0);

        T__ mu_kappa;
        (void) mu_kappa;  // dummy to suppress unused var warning
        if (jacobian__)
            mu_kappa = in__.scalar_lb_constrain(0,lp__);
        else
            mu_kappa = in__.scalar_lb_constrain(0);

        T__ sigma_kappa;
        (void) sigma_kappa;  // dummy to suppress unused var warning
        if (jacobian__)
            sigma_kappa = in__.scalar_lb_constrain(0,lp__);
        else
            sigma_kappa = in__.scalar_lb_constrain(0);


        // transformed parameters


        try {
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed parameters

        const char* function__ = "validate transformed params";
        (void) function__;  // dummy to suppress unused var warning

        // model body
        try {
            {
                validate_non_negative_index("vol", "n", n);
                Eigen::Matrix<T__,Eigen::Dynamic,1>  vol(static_cast<Eigen::VectorXd::Index>(n));
                (void) vol;  // dummy to suppress unused var warning

                stan::math::initialize(vol, DUMMY_VAR__);
                stan::math::fill(vol,DUMMY_VAR__);


                lp_accum__.add(normal_log<propto__>(mu_kappa, 1.5, 0.5));
                lp_accum__.add(normal_log<propto__>(sigma_kappa, 1, 0.5));
                lp_accum__.add(normal_log<propto__>(v0, prior_v0, 100));
                lp_accum__.add(lognormal_log<propto__>(kappa, mu_kappa, sigma_kappa));
                lp_accum__.add(normal_log<propto__>(tempt, 60, 20));
                lp_accum__.add(gamma_log<propto__>(sigma, 20, 0.5));
                stan::math::assign(vol, elt_multiply(elt_multiply(stan::model::rvalue(v0, stan::model::cons_list(stan::model::index_multi(record), stan::model::nil_index_list()), "v0"),add(1,elt_multiply(stan::model::rvalue(kappa, stan::model::cons_list(stan::model::index_multi(record), stan::model::nil_index_list()), "kappa"),elt_divide(minute,stan::model::rvalue(tempt, stan::model::cons_list(stan::model::index_multi(record), stan::model::nil_index_list()), "tempt"))))),exp(elt_divide(minus(minute),stan::model::rvalue(tempt, stan::model::cons_list(stan::model::index_multi(record), stan::model::nil_index_list()), "tempt")))));
                lp_accum__.add(normal_log<propto__>(volume, vol, sigma));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        lp_accum__.add(lp__);
        return lp_accum__.sum();

    } // log_prob()

    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }


    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("v0");
        names__.push_back("kappa");
        names__.push_back("tempt");
        names__.push_back("sigma");
        names__.push_back("mu_kappa");
        names__.push_back("sigma_kappa");
    }


    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(n_record);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n_record);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n_record);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
    }

    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        vars__.resize(0);
        stan::io::reader<double> in__(params_r__,params_i__);
        static const char* function__ = "model_linexp_gastro_1c_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        vector_d v0 = in__.vector_lb_constrain(0,n_record);
        vector_d kappa = in__.vector_lb_constrain(0,n_record);
        vector_d tempt = in__.vector_lb_constrain(0,n_record);
        double sigma = in__.scalar_lb_constrain(0);
        double mu_kappa = in__.scalar_lb_constrain(0);
        double sigma_kappa = in__.scalar_lb_constrain(0);
        for (int k_0__ = 0; k_0__ < n_record; ++k_0__) {
            vars__.push_back(v0[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < n_record; ++k_0__) {
            vars__.push_back(kappa[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < n_record; ++k_0__) {
            vars__.push_back(tempt[k_0__]);
        }
        vars__.push_back(sigma);
        vars__.push_back(mu_kappa);
        vars__.push_back(sigma_kappa);

        if (!include_tparams__) return;
        // declare and define transformed parameters
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;

        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning



        try {
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed parameters

        // write transformed parameters

        if (!include_gqs__) return;
        // declare and define generated quantities


        try {
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate generated quantities

        // write generated quantities
    }

    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng,params_r_vec,params_i_vec,vars_vec,include_tparams,include_gqs,pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }

    static std::string model_name() {
        return "model_linexp_gastro_1c";
    }


    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= n_record; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "v0" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= n_record; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "kappa" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= n_record; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "tempt" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "sigma";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_kappa";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "sigma_kappa";
        param_names__.push_back(param_name_stream__.str());

        if (!include_gqs__ && !include_tparams__) return;

        if (!include_gqs__) return;
    }


    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= n_record; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "v0" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= n_record; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "kappa" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= n_record; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "tempt" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "sigma";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_kappa";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "sigma_kappa";
        param_names__.push_back(param_name_stream__.str());

        if (!include_gqs__ && !include_tparams__) return;

        if (!include_gqs__) return;
    }

}; // model

}




// Code generated by Stan version 2.15.0

#include <stan/model/model_header.hpp>

namespace model_linexp_gastro_1d_namespace {

using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;

typedef Eigen::Matrix<double,Eigen::Dynamic,1> vector_d;
typedef Eigen::Matrix<double,1,Eigen::Dynamic> row_vector_d;
typedef Eigen::Matrix<double,Eigen::Dynamic,Eigen::Dynamic> matrix_d;

static int current_statement_begin__;

class model_linexp_gastro_1d : public prob_grad {
private:
    double prior_v0;
    int n;
    int n_record;
    vector<int> record;
    vector_d minute;
    vector_d volume;
public:
    model_linexp_gastro_1d(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        typedef boost::ecuyer1988 rng_t;
        rng_t base_rng(0);  // 0 seed default
        ctor_body(context__, base_rng, pstream__);
    }

    template <class RNG>
    model_linexp_gastro_1d(stan::io::var_context& context__,
        RNG& base_rng__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, base_rng__, pstream__);
    }

    template <class RNG>
    void ctor_body(stan::io::var_context& context__,
                   RNG& base_rng__,
                   std::ostream* pstream__) {
        current_statement_begin__ = -1;

        static const char* function__ = "model_linexp_gastro_1d_namespace::model_linexp_gastro_1d";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        // initialize member variables
        context__.validate_dims("data initialization", "prior_v0", "double", context__.to_vec());
        prior_v0 = double(0);
        vals_r__ = context__.vals_r("prior_v0");
        pos__ = 0;
        prior_v0 = vals_r__[pos__++];
        context__.validate_dims("data initialization", "n", "int", context__.to_vec());
        n = int(0);
        vals_i__ = context__.vals_i("n");
        pos__ = 0;
        n = vals_i__[pos__++];
        context__.validate_dims("data initialization", "n_record", "int", context__.to_vec());
        n_record = int(0);
        vals_i__ = context__.vals_i("n_record");
        pos__ = 0;
        n_record = vals_i__[pos__++];
        validate_non_negative_index("record", "n", n);
        context__.validate_dims("data initialization", "record", "int", context__.to_vec(n));
        validate_non_negative_index("record", "n", n);
        record = std::vector<int>(n,int(0));
        vals_i__ = context__.vals_i("record");
        pos__ = 0;
        size_t record_limit_0__ = n;
        for (size_t i_0__ = 0; i_0__ < record_limit_0__; ++i_0__) {
            record[i_0__] = vals_i__[pos__++];
        }
        validate_non_negative_index("minute", "n", n);
        context__.validate_dims("data initialization", "minute", "vector_d", context__.to_vec(n));
        validate_non_negative_index("minute", "n", n);
        minute = vector_d(static_cast<Eigen::VectorXd::Index>(n));
        vals_r__ = context__.vals_r("minute");
        pos__ = 0;
        size_t minute_i_vec_lim__ = n;
        for (size_t i_vec__ = 0; i_vec__ < minute_i_vec_lim__; ++i_vec__) {
            minute[i_vec__] = vals_r__[pos__++];
        }
        validate_non_negative_index("volume", "n", n);
        context__.validate_dims("data initialization", "volume", "vector_d", context__.to_vec(n));
        validate_non_negative_index("volume", "n", n);
        volume = vector_d(static_cast<Eigen::VectorXd::Index>(n));
        vals_r__ = context__.vals_r("volume");
        pos__ = 0;
        size_t volume_i_vec_lim__ = n;
        for (size_t i_vec__ = 0; i_vec__ < volume_i_vec_lim__; ++i_vec__) {
            volume[i_vec__] = vals_r__[pos__++];
        }

        // validate, data variables
        check_greater_or_equal(function__,"n",n,0);
        check_greater_or_equal(function__,"n_record",n_record,0);
        // initialize data variables

        try {
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed data

        // validate, set parameter ranges
        num_params_r__ = 0U;
        param_ranges_i__.clear();
        validate_non_negative_index("v0", "n_record", n_record);
        num_params_r__ += n_record;
        validate_non_negative_index("kappa", "n_record", n_record);
        num_params_r__ += n_record;
        validate_non_negative_index("tempt", "n_record", n_record);
        num_params_r__ += n_record;
        ++num_params_r__;
        ++num_params_r__;
        ++num_params_r__;
    }

    ~model_linexp_gastro_1d() { }


    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        stan::io::writer<double> writer__(params_r__,params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;

        if (!(context__.contains_r("v0")))
            throw std::runtime_error("variable v0 missing");
        vals_r__ = context__.vals_r("v0");
        pos__ = 0U;
        validate_non_negative_index("v0", "n_record", n_record);
        context__.validate_dims("initialization", "v0", "vector_d", context__.to_vec(n_record));
        // generate_declaration v0
        vector_d v0(static_cast<Eigen::VectorXd::Index>(n_record));
        for (int j1__ = 0U; j1__ < n_record; ++j1__)
            v0(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_lb_unconstrain(0,v0);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable v0: ") + e.what());
        }

        if (!(context__.contains_r("kappa")))
            throw std::runtime_error("variable kappa missing");
        vals_r__ = context__.vals_r("kappa");
        pos__ = 0U;
        validate_non_negative_index("kappa", "n_record", n_record);
        context__.validate_dims("initialization", "kappa", "vector_d", context__.to_vec(n_record));
        // generate_declaration kappa
        vector_d kappa(static_cast<Eigen::VectorXd::Index>(n_record));
        for (int j1__ = 0U; j1__ < n_record; ++j1__)
            kappa(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_lb_unconstrain(0,kappa);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable kappa: ") + e.what());
        }

        if (!(context__.contains_r("tempt")))
            throw std::runtime_error("variable tempt missing");
        vals_r__ = context__.vals_r("tempt");
        pos__ = 0U;
        validate_non_negative_index("tempt", "n_record", n_record);
        context__.validate_dims("initialization", "tempt", "vector_d", context__.to_vec(n_record));
        // generate_declaration tempt
        vector_d tempt(static_cast<Eigen::VectorXd::Index>(n_record));
        for (int j1__ = 0U; j1__ < n_record; ++j1__)
            tempt(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_lb_unconstrain(0,tempt);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable tempt: ") + e.what());
        }

        if (!(context__.contains_r("sigma")))
            throw std::runtime_error("variable sigma missing");
        vals_r__ = context__.vals_r("sigma");
        pos__ = 0U;
        context__.validate_dims("initialization", "sigma", "double", context__.to_vec());
        // generate_declaration sigma
        double sigma(0);
        sigma = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0,sigma);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable sigma: ") + e.what());
        }

        if (!(context__.contains_r("mu_kappa")))
            throw std::runtime_error("variable mu_kappa missing");
        vals_r__ = context__.vals_r("mu_kappa");
        pos__ = 0U;
        context__.validate_dims("initialization", "mu_kappa", "double", context__.to_vec());
        // generate_declaration mu_kappa
        double mu_kappa(0);
        mu_kappa = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0,mu_kappa);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable mu_kappa: ") + e.what());
        }

        if (!(context__.contains_r("sigma_kappa")))
            throw std::runtime_error("variable sigma_kappa missing");
        vals_r__ = context__.vals_r("sigma_kappa");
        pos__ = 0U;
        context__.validate_dims("initialization", "sigma_kappa", "double", context__.to_vec());
        // generate_declaration sigma_kappa
        double sigma_kappa(0);
        sigma_kappa = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0,sigma_kappa);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable sigma_kappa: ") + e.what());
        }

        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }

    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }


    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(vector<T__>& params_r__,
                 vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {

        T__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;

        // model parameters
        stan::io::reader<T__> in__(params_r__,params_i__);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  v0;
        (void) v0;  // dummy to suppress unused var warning
        if (jacobian__)
            v0 = in__.vector_lb_constrain(0,n_record,lp__);
        else
            v0 = in__.vector_lb_constrain(0,n_record);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  kappa;
        (void) kappa;  // dummy to suppress unused var warning
        if (jacobian__)
            kappa = in__.vector_lb_constrain(0,n_record,lp__);
        else
            kappa = in__.vector_lb_constrain(0,n_record);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  tempt;
        (void) tempt;  // dummy to suppress unused var warning
        if (jacobian__)
            tempt = in__.vector_lb_constrain(0,n_record,lp__);
        else
            tempt = in__.vector_lb_constrain(0,n_record);

        T__ sigma;
        (void) sigma;  // dummy to suppress unused var warning
        if (jacobian__)
            sigma = in__.scalar_lb_constrain(0,lp__);
        else
            sigma = in__.scalar_lb_constrain(0);

        T__ mu_kappa;
        (void) mu_kappa;  // dummy to suppress unused var warning
        if (jacobian__)
            mu_kappa = in__.scalar_lb_constrain(0,lp__);
        else
            mu_kappa = in__.scalar_lb_constrain(0);

        T__ sigma_kappa;
        (void) sigma_kappa;  // dummy to suppress unused var warning
        if (jacobian__)
            sigma_kappa = in__.scalar_lb_constrain(0,lp__);
        else
            sigma_kappa = in__.scalar_lb_constrain(0);


        // transformed parameters
        validate_non_negative_index("mt", "n", n);
        Eigen::Matrix<T__,Eigen::Dynamic,1>  mt(static_cast<Eigen::VectorXd::Index>(n));
        (void) mt;  // dummy to suppress unused var warning

        stan::math::initialize(mt, DUMMY_VAR__);
        stan::math::fill(mt,DUMMY_VAR__);


        try {
            stan::math::assign(mt, elt_divide(minute,stan::model::rvalue(tempt, stan::model::cons_list(stan::model::index_multi(record), stan::model::nil_index_list()), "tempt")));
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed parameters
        for (int i0__ = 0; i0__ < n; ++i0__) {
            if (stan::math::is_uninitialized(mt(i0__))) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: mt" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }

        const char* function__ = "validate transformed params";
        (void) function__;  // dummy to suppress unused var warning

        // model body
        try {
            {
                validate_non_negative_index("vol", "n", n);
                Eigen::Matrix<T__,Eigen::Dynamic,1>  vol(static_cast<Eigen::VectorXd::Index>(n));
                (void) vol;  // dummy to suppress unused var warning

                stan::math::initialize(vol, DUMMY_VAR__);
                stan::math::fill(vol,DUMMY_VAR__);


                lp_accum__.add(normal_log<propto__>(mu_kappa, 1.5, 0.5));
                lp_accum__.add(normal_log<propto__>(sigma_kappa, 1, 0.5));
                lp_accum__.add(normal_log<propto__>(v0, prior_v0, 100));
                lp_accum__.add(lognormal_log<propto__>(kappa, mu_kappa, sigma_kappa));
                lp_accum__.add(normal_log<propto__>(tempt, 60.0, 20.0));
                lp_accum__.add(gamma_log<propto__>(sigma, 20.0, 0.5));
                stan::math::assign(vol, elt_multiply(elt_multiply(stan::model::rvalue(v0, stan::model::cons_list(stan::model::index_multi(record), stan::model::nil_index_list()), "v0"),add(1,elt_multiply(stan::model::rvalue(kappa, stan::model::cons_list(stan::model::index_multi(record), stan::model::nil_index_list()), "kappa"),mt))),exp(minus(mt))));
                lp_accum__.add(normal_log<propto__>(volume, vol, sigma));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        lp_accum__.add(lp__);
        return lp_accum__.sum();

    } // log_prob()

    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }


    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("v0");
        names__.push_back("kappa");
        names__.push_back("tempt");
        names__.push_back("sigma");
        names__.push_back("mu_kappa");
        names__.push_back("sigma_kappa");
        names__.push_back("mt");
    }


    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(n_record);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n_record);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n_record);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n);
        dimss__.push_back(dims__);
    }

    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        vars__.resize(0);
        stan::io::reader<double> in__(params_r__,params_i__);
        static const char* function__ = "model_linexp_gastro_1d_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        vector_d v0 = in__.vector_lb_constrain(0,n_record);
        vector_d kappa = in__.vector_lb_constrain(0,n_record);
        vector_d tempt = in__.vector_lb_constrain(0,n_record);
        double sigma = in__.scalar_lb_constrain(0);
        double mu_kappa = in__.scalar_lb_constrain(0);
        double sigma_kappa = in__.scalar_lb_constrain(0);
        for (int k_0__ = 0; k_0__ < n_record; ++k_0__) {
            vars__.push_back(v0[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < n_record; ++k_0__) {
            vars__.push_back(kappa[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < n_record; ++k_0__) {
            vars__.push_back(tempt[k_0__]);
        }
        vars__.push_back(sigma);
        vars__.push_back(mu_kappa);
        vars__.push_back(sigma_kappa);

        if (!include_tparams__) return;
        // declare and define transformed parameters
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;

        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        validate_non_negative_index("mt", "n", n);
        vector_d mt(static_cast<Eigen::VectorXd::Index>(n));
        (void) mt;  // dummy to suppress unused var warning

        stan::math::initialize(mt, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(mt,DUMMY_VAR__);


        try {
            stan::math::assign(mt, elt_divide(minute,stan::model::rvalue(tempt, stan::model::cons_list(stan::model::index_multi(record), stan::model::nil_index_list()), "tempt")));
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed parameters

        // write transformed parameters
        for (int k_0__ = 0; k_0__ < n; ++k_0__) {
            vars__.push_back(mt[k_0__]);
        }

        if (!include_gqs__) return;
        // declare and define generated quantities


        try {
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate generated quantities

        // write generated quantities
    }

    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng,params_r_vec,params_i_vec,vars_vec,include_tparams,include_gqs,pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }

    static std::string model_name() {
        return "model_linexp_gastro_1d";
    }


    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= n_record; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "v0" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= n_record; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "kappa" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= n_record; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "tempt" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "sigma";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_kappa";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "sigma_kappa";
        param_names__.push_back(param_name_stream__.str());

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_0__ = 1; k_0__ <= n; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mt" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
    }


    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= n_record; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "v0" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= n_record; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "kappa" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= n_record; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "tempt" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "sigma";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_kappa";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "sigma_kappa";
        param_names__.push_back(param_name_stream__.str());

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_0__ = 1; k_0__ <= n; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mt" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
    }

}; // model

}




// Code generated by Stan version 2.15.0

#include <stan/model/model_header.hpp>

namespace model_linexp_gastro_2b_namespace {

using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;

typedef Eigen::Matrix<double,Eigen::Dynamic,1> vector_d;
typedef Eigen::Matrix<double,1,Eigen::Dynamic> row_vector_d;
typedef Eigen::Matrix<double,Eigen::Dynamic,Eigen::Dynamic> matrix_d;

static int current_statement_begin__;

class model_linexp_gastro_2b : public prob_grad {
private:
    double lkj;
    int student_df;
    int n;
    int n_record;
    vector<int> record;
    vector_d minute;
    vector_d volume;
    vector_d zeros;
    vector_d volume_1;
    double norm_vol;
    int n_norm;
public:
    model_linexp_gastro_2b(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        typedef boost::ecuyer1988 rng_t;
        rng_t base_rng(0);  // 0 seed default
        ctor_body(context__, base_rng, pstream__);
    }

    template <class RNG>
    model_linexp_gastro_2b(stan::io::var_context& context__,
        RNG& base_rng__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, base_rng__, pstream__);
    }

    template <class RNG>
    void ctor_body(stan::io::var_context& context__,
                   RNG& base_rng__,
                   std::ostream* pstream__) {
        current_statement_begin__ = -1;

        static const char* function__ = "model_linexp_gastro_2b_namespace::model_linexp_gastro_2b";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        // initialize member variables
        context__.validate_dims("data initialization", "lkj", "double", context__.to_vec());
        lkj = double(0);
        vals_r__ = context__.vals_r("lkj");
        pos__ = 0;
        lkj = vals_r__[pos__++];
        context__.validate_dims("data initialization", "student_df", "int", context__.to_vec());
        student_df = int(0);
        vals_i__ = context__.vals_i("student_df");
        pos__ = 0;
        student_df = vals_i__[pos__++];
        context__.validate_dims("data initialization", "n", "int", context__.to_vec());
        n = int(0);
        vals_i__ = context__.vals_i("n");
        pos__ = 0;
        n = vals_i__[pos__++];
        context__.validate_dims("data initialization", "n_record", "int", context__.to_vec());
        n_record = int(0);
        vals_i__ = context__.vals_i("n_record");
        pos__ = 0;
        n_record = vals_i__[pos__++];
        validate_non_negative_index("record", "n", n);
        context__.validate_dims("data initialization", "record", "int", context__.to_vec(n));
        validate_non_negative_index("record", "n", n);
        record = std::vector<int>(n,int(0));
        vals_i__ = context__.vals_i("record");
        pos__ = 0;
        size_t record_limit_0__ = n;
        for (size_t i_0__ = 0; i_0__ < record_limit_0__; ++i_0__) {
            record[i_0__] = vals_i__[pos__++];
        }
        validate_non_negative_index("minute", "n", n);
        context__.validate_dims("data initialization", "minute", "vector_d", context__.to_vec(n));
        validate_non_negative_index("minute", "n", n);
        minute = vector_d(static_cast<Eigen::VectorXd::Index>(n));
        vals_r__ = context__.vals_r("minute");
        pos__ = 0;
        size_t minute_i_vec_lim__ = n;
        for (size_t i_vec__ = 0; i_vec__ < minute_i_vec_lim__; ++i_vec__) {
            minute[i_vec__] = vals_r__[pos__++];
        }
        validate_non_negative_index("volume", "n", n);
        context__.validate_dims("data initialization", "volume", "vector_d", context__.to_vec(n));
        validate_non_negative_index("volume", "n", n);
        volume = vector_d(static_cast<Eigen::VectorXd::Index>(n));
        vals_r__ = context__.vals_r("volume");
        pos__ = 0;
        size_t volume_i_vec_lim__ = n;
        for (size_t i_vec__ = 0; i_vec__ < volume_i_vec_lim__; ++i_vec__) {
            volume[i_vec__] = vals_r__[pos__++];
        }

        // validate, data variables
        check_greater_or_equal(function__,"n",n,0);
        check_greater_or_equal(function__,"n_record",n_record,0);
        // initialize data variables
        validate_non_negative_index("zeros", "2", 2);
        zeros = vector_d(static_cast<Eigen::VectorXd::Index>(2));
        stan::math::fill(zeros,DUMMY_VAR__);
        validate_non_negative_index("volume_1", "n", n);
        volume_1 = vector_d(static_cast<Eigen::VectorXd::Index>(n));
        stan::math::fill(volume_1,DUMMY_VAR__);
        norm_vol = double(0);
        stan::math::fill(norm_vol,DUMMY_VAR__);
        n_norm = int(0);
        stan::math::fill(n_norm, std::numeric_limits<int>::min());

        try {
            stan::math::assign(get_base1_lhs(zeros,1,"zeros",1), 0);
            stan::math::assign(get_base1_lhs(zeros,2,"zeros",1), 0);
            stan::math::assign(n_norm, 0);
            stan::math::assign(norm_vol, 0);
            for (int i = 1; i <= n; ++i) {

                if (as_bool(logical_lt(get_base1(minute,i,"minute",1),5))) {

                    stan::math::assign(norm_vol, (norm_vol + get_base1(volume,i,"volume",1)));
                    stan::math::assign(n_norm, (n_norm + 1));
                }
            }
            stan::math::assign(norm_vol, (norm_vol / n_norm));
            stan::math::assign(volume_1, divide(volume,norm_vol));
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed data

        // validate, set parameter ranges
        num_params_r__ = 0U;
        param_ranges_i__.clear();
        validate_non_negative_index("v0_1", "n_record", n_record);
        num_params_r__ += n_record;
        validate_non_negative_index("sigma_record", "2", 2);
        num_params_r__ += 2;
        ++num_params_r__;
        ++num_params_r__;
        validate_non_negative_index("rho", "2", 2);
        num_params_r__ += ((2 * (2 - 1)) / 2);
        ++num_params_r__;
        validate_non_negative_index("cf", "2", 2);
        validate_non_negative_index("cf", "n_record", n_record);
        num_params_r__ += 2 * n_record;
    }

    ~model_linexp_gastro_2b() { }


    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        stan::io::writer<double> writer__(params_r__,params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;

        if (!(context__.contains_r("v0_1")))
            throw std::runtime_error("variable v0_1 missing");
        vals_r__ = context__.vals_r("v0_1");
        pos__ = 0U;
        validate_non_negative_index("v0_1", "n_record", n_record);
        context__.validate_dims("initialization", "v0_1", "vector_d", context__.to_vec(n_record));
        // generate_declaration v0_1
        vector_d v0_1(static_cast<Eigen::VectorXd::Index>(n_record));
        for (int j1__ = 0U; j1__ < n_record; ++j1__)
            v0_1(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_lb_unconstrain(0,v0_1);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable v0_1: ") + e.what());
        }

        if (!(context__.contains_r("sigma_record")))
            throw std::runtime_error("variable sigma_record missing");
        vals_r__ = context__.vals_r("sigma_record");
        pos__ = 0U;
        validate_non_negative_index("sigma_record", "2", 2);
        context__.validate_dims("initialization", "sigma_record", "vector_d", context__.to_vec(2));
        // generate_declaration sigma_record
        vector_d sigma_record(static_cast<Eigen::VectorXd::Index>(2));
        for (int j1__ = 0U; j1__ < 2; ++j1__)
            sigma_record(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_lb_unconstrain(0,sigma_record);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable sigma_record: ") + e.what());
        }

        if (!(context__.contains_r("mu_kappa")))
            throw std::runtime_error("variable mu_kappa missing");
        vals_r__ = context__.vals_r("mu_kappa");
        pos__ = 0U;
        context__.validate_dims("initialization", "mu_kappa", "double", context__.to_vec());
        // generate_declaration mu_kappa
        double mu_kappa(0);
        mu_kappa = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0,mu_kappa);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable mu_kappa: ") + e.what());
        }

        if (!(context__.contains_r("mu_tempt")))
            throw std::runtime_error("variable mu_tempt missing");
        vals_r__ = context__.vals_r("mu_tempt");
        pos__ = 0U;
        context__.validate_dims("initialization", "mu_tempt", "double", context__.to_vec());
        // generate_declaration mu_tempt
        double mu_tempt(0);
        mu_tempt = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0,mu_tempt);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable mu_tempt: ") + e.what());
        }

        if (!(context__.contains_r("rho")))
            throw std::runtime_error("variable rho missing");
        vals_r__ = context__.vals_r("rho");
        pos__ = 0U;
        validate_non_negative_index("rho", "2", 2);
        validate_non_negative_index("rho", "2", 2);
        context__.validate_dims("initialization", "rho", "matrix_d", context__.to_vec(2,2));
        // generate_declaration rho
        matrix_d rho(static_cast<Eigen::VectorXd::Index>(2),static_cast<Eigen::VectorXd::Index>(2));
        for (int j2__ = 0U; j2__ < 2; ++j2__)
            for (int j1__ = 0U; j1__ < 2; ++j1__)
                rho(j1__,j2__) = vals_r__[pos__++];
        try {
            writer__.corr_matrix_unconstrain(rho);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable rho: ") + e.what());
        }

        if (!(context__.contains_r("sigma")))
            throw std::runtime_error("variable sigma missing");
        vals_r__ = context__.vals_r("sigma");
        pos__ = 0U;
        context__.validate_dims("initialization", "sigma", "double", context__.to_vec());
        // generate_declaration sigma
        double sigma(0);
        sigma = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0,sigma);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable sigma: ") + e.what());
        }

        if (!(context__.contains_r("cf")))
            throw std::runtime_error("variable cf missing");
        vals_r__ = context__.vals_r("cf");
        pos__ = 0U;
        validate_non_negative_index("cf", "n_record", n_record);
        validate_non_negative_index("cf", "2", 2);
        context__.validate_dims("initialization", "cf", "vector_d", context__.to_vec(n_record,2));
        // generate_declaration cf
        std::vector<vector_d> cf(n_record,vector_d(static_cast<Eigen::VectorXd::Index>(2)));
        for (int j1__ = 0U; j1__ < 2; ++j1__)
            for (int i0__ = 0U; i0__ < n_record; ++i0__)
                cf[i0__](j1__) = vals_r__[pos__++];
        for (int i0__ = 0U; i0__ < n_record; ++i0__)
            try {
            writer__.vector_unconstrain(cf[i0__]);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable cf: ") + e.what());
        }

        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }

    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }


    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(vector<T__>& params_r__,
                 vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {

        T__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;

        // model parameters
        stan::io::reader<T__> in__(params_r__,params_i__);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  v0_1;
        (void) v0_1;  // dummy to suppress unused var warning
        if (jacobian__)
            v0_1 = in__.vector_lb_constrain(0,n_record,lp__);
        else
            v0_1 = in__.vector_lb_constrain(0,n_record);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  sigma_record;
        (void) sigma_record;  // dummy to suppress unused var warning
        if (jacobian__)
            sigma_record = in__.vector_lb_constrain(0,2,lp__);
        else
            sigma_record = in__.vector_lb_constrain(0,2);

        T__ mu_kappa;
        (void) mu_kappa;  // dummy to suppress unused var warning
        if (jacobian__)
            mu_kappa = in__.scalar_lb_constrain(0,lp__);
        else
            mu_kappa = in__.scalar_lb_constrain(0);

        T__ mu_tempt;
        (void) mu_tempt;  // dummy to suppress unused var warning
        if (jacobian__)
            mu_tempt = in__.scalar_lb_constrain(0,lp__);
        else
            mu_tempt = in__.scalar_lb_constrain(0);

        Eigen::Matrix<T__,Eigen::Dynamic,Eigen::Dynamic>  rho;
        (void) rho;  // dummy to suppress unused var warning
        if (jacobian__)
            rho = in__.corr_matrix_constrain(2,lp__);
        else
            rho = in__.corr_matrix_constrain(2);

        T__ sigma;
        (void) sigma;  // dummy to suppress unused var warning
        if (jacobian__)
            sigma = in__.scalar_lb_constrain(0,lp__);
        else
            sigma = in__.scalar_lb_constrain(0);

        vector<Eigen::Matrix<T__,Eigen::Dynamic,1> > cf;
        size_t dim_cf_0__ = n_record;
        cf.reserve(dim_cf_0__);
        for (size_t k_0__ = 0; k_0__ < dim_cf_0__; ++k_0__) {
            if (jacobian__)
                cf.push_back(in__.vector_constrain(2,lp__));
            else
                cf.push_back(in__.vector_constrain(2));
        }


        // transformed parameters
        validate_non_negative_index("sigma_cf", "2", 2);
        validate_non_negative_index("sigma_cf", "2", 2);
        Eigen::Matrix<T__,Eigen::Dynamic,Eigen::Dynamic>  sigma_cf(static_cast<Eigen::VectorXd::Index>(2),static_cast<Eigen::VectorXd::Index>(2));
        (void) sigma_cf;  // dummy to suppress unused var warning

        stan::math::initialize(sigma_cf, DUMMY_VAR__);
        stan::math::fill(sigma_cf,DUMMY_VAR__);


        try {
            stan::math::assign(sigma_cf, quad_form_diag(rho,sigma_record));
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed parameters
        for (int i0__ = 0; i0__ < 2; ++i0__) {
            for (int i1__ = 0; i1__ < 2; ++i1__) {
                if (stan::math::is_uninitialized(sigma_cf(i0__,i1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: sigma_cf" << '[' << i0__ << ']' << '[' << i1__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }
        }

        const char* function__ = "validate transformed params";
        (void) function__;  // dummy to suppress unused var warning

        // model body
        try {
            {
                int rec(0);
                (void) rec;  // dummy to suppress unused var warning

                stan::math::fill(rec, std::numeric_limits<int>::min());
                T__ v0r;
                (void) v0r;  // dummy to suppress unused var warning

                stan::math::initialize(v0r, DUMMY_VAR__);
                stan::math::fill(v0r,DUMMY_VAR__);
                T__ kappar;
                (void) kappar;  // dummy to suppress unused var warning

                stan::math::initialize(kappar, DUMMY_VAR__);
                stan::math::fill(kappar,DUMMY_VAR__);
                T__ temptr;
                (void) temptr;  // dummy to suppress unused var warning

                stan::math::initialize(temptr, DUMMY_VAR__);
                stan::math::fill(temptr,DUMMY_VAR__);
                validate_non_negative_index("mu", "n", n);
                Eigen::Matrix<T__,Eigen::Dynamic,1>  mu(static_cast<Eigen::VectorXd::Index>(n));
                (void) mu;  // dummy to suppress unused var warning

                stan::math::initialize(mu, DUMMY_VAR__);
                stan::math::fill(mu,DUMMY_VAR__);


                lp_accum__.add(lkj_corr_log<propto__>(rho, lkj));
                lp_accum__.add(normal_log<propto__>(v0_1, 1, 0.29999999999999999));
                lp_accum__.add(multi_normal_log<propto__>(cf, zeros, sigma_cf));
                lp_accum__.add(normal_log<propto__>(mu_kappa, 0.80000000000000004, 0.29999999999999999));
                lp_accum__.add(normal_log<propto__>(mu_tempt, 40, 20));
                lp_accum__.add(cauchy_log<propto__>(get_base1(sigma_record,1,"sigma_record",1), 0, 20));
                lp_accum__.add(cauchy_log<propto__>(get_base1(sigma_record,2,"sigma_record",1), 0, 0.40000000000000002));
                lp_accum__.add(cauchy_log<propto__>(sigma, 0.0, 0.10000000000000001));
                for (int i = 1; i <= n; ++i) {

                    stan::math::assign(rec, get_base1(record,i,"record",1));
                    stan::math::assign(v0r, get_base1(v0_1,rec,"v0_1",1));
                    stan::math::assign(temptr, (mu_tempt + get_base1(get_base1(cf,rec,"cf",1),1,"cf",2)));
                    stan::math::assign(kappar, (mu_kappa + get_base1(get_base1(cf,rec,"cf",1),2,"cf",2)));
                    stan::math::assign(get_base1_lhs(mu,i,"mu",1), ((v0r * (1 + ((kappar * get_base1(minute,i,"minute",1)) / temptr))) * exp((-(get_base1(minute,i,"minute",1)) / temptr))));
                }
                lp_accum__.add(student_t_log<propto__>(volume_1, student_df, mu, sigma));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        lp_accum__.add(lp__);
        return lp_accum__.sum();

    } // log_prob()

    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }


    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("v0_1");
        names__.push_back("sigma_record");
        names__.push_back("mu_kappa");
        names__.push_back("mu_tempt");
        names__.push_back("rho");
        names__.push_back("sigma");
        names__.push_back("cf");
        names__.push_back("sigma_cf");
        names__.push_back("v0");
        names__.push_back("tempt");
        names__.push_back("kappa");
    }


    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(n_record);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(2);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(2);
        dims__.push_back(2);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n_record);
        dims__.push_back(2);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(2);
        dims__.push_back(2);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n_record);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n_record);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n_record);
        dimss__.push_back(dims__);
    }

    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        vars__.resize(0);
        stan::io::reader<double> in__(params_r__,params_i__);
        static const char* function__ = "model_linexp_gastro_2b_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        vector_d v0_1 = in__.vector_lb_constrain(0,n_record);
        vector_d sigma_record = in__.vector_lb_constrain(0,2);
        double mu_kappa = in__.scalar_lb_constrain(0);
        double mu_tempt = in__.scalar_lb_constrain(0);
        matrix_d rho = in__.corr_matrix_constrain(2);
        double sigma = in__.scalar_lb_constrain(0);
        vector<vector_d> cf;
        size_t dim_cf_0__ = n_record;
        for (size_t k_0__ = 0; k_0__ < dim_cf_0__; ++k_0__) {
            cf.push_back(in__.vector_constrain(2));
        }
        for (int k_0__ = 0; k_0__ < n_record; ++k_0__) {
            vars__.push_back(v0_1[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < 2; ++k_0__) {
            vars__.push_back(sigma_record[k_0__]);
        }
        vars__.push_back(mu_kappa);
        vars__.push_back(mu_tempt);
        for (int k_1__ = 0; k_1__ < 2; ++k_1__) {
            for (int k_0__ = 0; k_0__ < 2; ++k_0__) {
                vars__.push_back(rho(k_0__, k_1__));
            }
        }
        vars__.push_back(sigma);
        for (int k_1__ = 0; k_1__ < 2; ++k_1__) {
            for (int k_0__ = 0; k_0__ < n_record; ++k_0__) {
                vars__.push_back(cf[k_0__][k_1__]);
            }
        }

        if (!include_tparams__) return;
        // declare and define transformed parameters
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;

        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        validate_non_negative_index("sigma_cf", "2", 2);
        validate_non_negative_index("sigma_cf", "2", 2);
        matrix_d sigma_cf(static_cast<Eigen::VectorXd::Index>(2),static_cast<Eigen::VectorXd::Index>(2));
        (void) sigma_cf;  // dummy to suppress unused var warning

        stan::math::initialize(sigma_cf, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(sigma_cf,DUMMY_VAR__);


        try {
            stan::math::assign(sigma_cf, quad_form_diag(rho,sigma_record));
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed parameters

        // write transformed parameters
        for (int k_1__ = 0; k_1__ < 2; ++k_1__) {
            for (int k_0__ = 0; k_0__ < 2; ++k_0__) {
                vars__.push_back(sigma_cf(k_0__, k_1__));
            }
        }

        if (!include_gqs__) return;
        // declare and define generated quantities
        validate_non_negative_index("v0", "n_record", n_record);
        vector_d v0(static_cast<Eigen::VectorXd::Index>(n_record));
        (void) v0;  // dummy to suppress unused var warning

        stan::math::initialize(v0, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(v0,DUMMY_VAR__);
        validate_non_negative_index("tempt", "n_record", n_record);
        vector_d tempt(static_cast<Eigen::VectorXd::Index>(n_record));
        (void) tempt;  // dummy to suppress unused var warning

        stan::math::initialize(tempt, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(tempt,DUMMY_VAR__);
        validate_non_negative_index("kappa", "n_record", n_record);
        vector_d kappa(static_cast<Eigen::VectorXd::Index>(n_record));
        (void) kappa;  // dummy to suppress unused var warning

        stan::math::initialize(kappa, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(kappa,DUMMY_VAR__);


        try {
            stan::math::assign(v0, multiply(v0_1,norm_vol));
            for (int i = 1; i <= n_record; ++i) {

                stan::math::assign(get_base1_lhs(tempt,i,"tempt",1), (mu_tempt + get_base1(get_base1(cf,i,"cf",1),1,"cf",2)));
                stan::math::assign(get_base1_lhs(kappa,i,"kappa",1), (mu_kappa + get_base1(get_base1(cf,i,"cf",1),2,"cf",2)));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate generated quantities

        // write generated quantities
        for (int k_0__ = 0; k_0__ < n_record; ++k_0__) {
            vars__.push_back(v0[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < n_record; ++k_0__) {
            vars__.push_back(tempt[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < n_record; ++k_0__) {
            vars__.push_back(kappa[k_0__]);
        }

    }

    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng,params_r_vec,params_i_vec,vars_vec,include_tparams,include_gqs,pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }

    static std::string model_name() {
        return "model_linexp_gastro_2b";
    }


    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= n_record; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "v0_1" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= 2; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma_record" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_kappa";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_tempt";
        param_names__.push_back(param_name_stream__.str());
        for (int k_1__ = 1; k_1__ <= 2; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= 2; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "rho" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "sigma";
        param_names__.push_back(param_name_stream__.str());
        for (int k_1__ = 1; k_1__ <= 2; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= n_record; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "cf" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_1__ = 1; k_1__ <= 2; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= 2; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "sigma_cf" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }

        if (!include_gqs__) return;
        for (int k_0__ = 1; k_0__ <= n_record; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "v0" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= n_record; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "tempt" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= n_record; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "kappa" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
    }


    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= n_record; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "v0_1" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= 2; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma_record" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_kappa";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_tempt";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= ((2 * (2 - 1)) / 2); ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "rho" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "sigma";
        param_names__.push_back(param_name_stream__.str());
        for (int k_1__ = 1; k_1__ <= 2; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= n_record; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "cf" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_1__ = 1; k_1__ <= 2; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= 2; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "sigma_cf" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }

        if (!include_gqs__) return;
        for (int k_0__ = 1; k_0__ <= n_record; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "v0" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= n_record; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "tempt" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= n_record; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "kappa" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
    }

}; // model

}




// Code generated by Stan version 2.15.0

#include <stan/model/model_header.hpp>

namespace model_linexp_gastro_2c_namespace {

using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;

typedef Eigen::Matrix<double,Eigen::Dynamic,1> vector_d;
typedef Eigen::Matrix<double,1,Eigen::Dynamic> row_vector_d;
typedef Eigen::Matrix<double,Eigen::Dynamic,Eigen::Dynamic> matrix_d;

static int current_statement_begin__;

class model_linexp_gastro_2c : public prob_grad {
private:
    double lkj;
    int student_df;
    int n;
    int n_record;
    vector<int> record;
    vector_d minute;
    vector_d volume;
    vector_d volume_1;
    double norm_vol;
    int n_norm;
public:
    model_linexp_gastro_2c(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        typedef boost::ecuyer1988 rng_t;
        rng_t base_rng(0);  // 0 seed default
        ctor_body(context__, base_rng, pstream__);
    }

    template <class RNG>
    model_linexp_gastro_2c(stan::io::var_context& context__,
        RNG& base_rng__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, base_rng__, pstream__);
    }

    template <class RNG>
    void ctor_body(stan::io::var_context& context__,
                   RNG& base_rng__,
                   std::ostream* pstream__) {
        current_statement_begin__ = -1;

        static const char* function__ = "model_linexp_gastro_2c_namespace::model_linexp_gastro_2c";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        // initialize member variables
        context__.validate_dims("data initialization", "lkj", "double", context__.to_vec());
        lkj = double(0);
        vals_r__ = context__.vals_r("lkj");
        pos__ = 0;
        lkj = vals_r__[pos__++];
        context__.validate_dims("data initialization", "student_df", "int", context__.to_vec());
        student_df = int(0);
        vals_i__ = context__.vals_i("student_df");
        pos__ = 0;
        student_df = vals_i__[pos__++];
        context__.validate_dims("data initialization", "n", "int", context__.to_vec());
        n = int(0);
        vals_i__ = context__.vals_i("n");
        pos__ = 0;
        n = vals_i__[pos__++];
        context__.validate_dims("data initialization", "n_record", "int", context__.to_vec());
        n_record = int(0);
        vals_i__ = context__.vals_i("n_record");
        pos__ = 0;
        n_record = vals_i__[pos__++];
        validate_non_negative_index("record", "n", n);
        context__.validate_dims("data initialization", "record", "int", context__.to_vec(n));
        validate_non_negative_index("record", "n", n);
        record = std::vector<int>(n,int(0));
        vals_i__ = context__.vals_i("record");
        pos__ = 0;
        size_t record_limit_0__ = n;
        for (size_t i_0__ = 0; i_0__ < record_limit_0__; ++i_0__) {
            record[i_0__] = vals_i__[pos__++];
        }
        validate_non_negative_index("minute", "n", n);
        context__.validate_dims("data initialization", "minute", "vector_d", context__.to_vec(n));
        validate_non_negative_index("minute", "n", n);
        minute = vector_d(static_cast<Eigen::VectorXd::Index>(n));
        vals_r__ = context__.vals_r("minute");
        pos__ = 0;
        size_t minute_i_vec_lim__ = n;
        for (size_t i_vec__ = 0; i_vec__ < minute_i_vec_lim__; ++i_vec__) {
            minute[i_vec__] = vals_r__[pos__++];
        }
        validate_non_negative_index("volume", "n", n);
        context__.validate_dims("data initialization", "volume", "vector_d", context__.to_vec(n));
        validate_non_negative_index("volume", "n", n);
        volume = vector_d(static_cast<Eigen::VectorXd::Index>(n));
        vals_r__ = context__.vals_r("volume");
        pos__ = 0;
        size_t volume_i_vec_lim__ = n;
        for (size_t i_vec__ = 0; i_vec__ < volume_i_vec_lim__; ++i_vec__) {
            volume[i_vec__] = vals_r__[pos__++];
        }

        // validate, data variables
        check_greater_or_equal(function__,"n",n,0);
        check_greater_or_equal(function__,"n_record",n_record,0);
        // initialize data variables
        validate_non_negative_index("volume_1", "n", n);
        volume_1 = vector_d(static_cast<Eigen::VectorXd::Index>(n));
        stan::math::fill(volume_1,DUMMY_VAR__);
        norm_vol = double(0);
        stan::math::fill(norm_vol,DUMMY_VAR__);
        n_norm = int(0);
        stan::math::fill(n_norm, std::numeric_limits<int>::min());

        try {
            stan::math::assign(n_norm, 0);
            stan::math::assign(norm_vol, 0);
            for (int i = 1; i <= n; ++i) {

                if (as_bool(logical_lt(get_base1(minute,i,"minute",1),5))) {

                    stan::math::assign(norm_vol, (norm_vol + get_base1(volume,i,"volume",1)));
                    stan::math::assign(n_norm, (n_norm + 1));
                }
            }
            stan::math::assign(norm_vol, (norm_vol / n_norm));
            stan::math::assign(volume_1, divide(volume,norm_vol));
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed data

        // validate, set parameter ranges
        num_params_r__ = 0U;
        param_ranges_i__.clear();
        validate_non_negative_index("v0_1", "n_record", n_record);
        num_params_r__ += n_record;
        validate_non_negative_index("sigma_record", "2", 2);
        num_params_r__ += 2;
        ++num_params_r__;
        ++num_params_r__;
        ++num_params_r__;
        validate_non_negative_index("L_rho", "2", 2);
        num_params_r__ += ((2 * (2 - 1)) / 2);
        validate_non_negative_index("z", "2", 2);
        validate_non_negative_index("z", "n_record", n_record);
        num_params_r__ += 2 * n_record;
    }

    ~model_linexp_gastro_2c() { }


    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        stan::io::writer<double> writer__(params_r__,params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;

        if (!(context__.contains_r("v0_1")))
            throw std::runtime_error("variable v0_1 missing");
        vals_r__ = context__.vals_r("v0_1");
        pos__ = 0U;
        validate_non_negative_index("v0_1", "n_record", n_record);
        context__.validate_dims("initialization", "v0_1", "vector_d", context__.to_vec(n_record));
        // generate_declaration v0_1
        vector_d v0_1(static_cast<Eigen::VectorXd::Index>(n_record));
        for (int j1__ = 0U; j1__ < n_record; ++j1__)
            v0_1(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_lub_unconstrain(0,2,v0_1);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable v0_1: ") + e.what());
        }

        if (!(context__.contains_r("sigma_record")))
            throw std::runtime_error("variable sigma_record missing");
        vals_r__ = context__.vals_r("sigma_record");
        pos__ = 0U;
        validate_non_negative_index("sigma_record", "2", 2);
        context__.validate_dims("initialization", "sigma_record", "vector_d", context__.to_vec(2));
        // generate_declaration sigma_record
        vector_d sigma_record(static_cast<Eigen::VectorXd::Index>(2));
        for (int j1__ = 0U; j1__ < 2; ++j1__)
            sigma_record(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_lb_unconstrain(0,sigma_record);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable sigma_record: ") + e.what());
        }

        if (!(context__.contains_r("mu_kappa")))
            throw std::runtime_error("variable mu_kappa missing");
        vals_r__ = context__.vals_r("mu_kappa");
        pos__ = 0U;
        context__.validate_dims("initialization", "mu_kappa", "double", context__.to_vec());
        // generate_declaration mu_kappa
        double mu_kappa(0);
        mu_kappa = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0,mu_kappa);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable mu_kappa: ") + e.what());
        }

        if (!(context__.contains_r("mu_tempt")))
            throw std::runtime_error("variable mu_tempt missing");
        vals_r__ = context__.vals_r("mu_tempt");
        pos__ = 0U;
        context__.validate_dims("initialization", "mu_tempt", "double", context__.to_vec());
        // generate_declaration mu_tempt
        double mu_tempt(0);
        mu_tempt = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0,mu_tempt);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable mu_tempt: ") + e.what());
        }

        if (!(context__.contains_r("sigma")))
            throw std::runtime_error("variable sigma missing");
        vals_r__ = context__.vals_r("sigma");
        pos__ = 0U;
        context__.validate_dims("initialization", "sigma", "double", context__.to_vec());
        // generate_declaration sigma
        double sigma(0);
        sigma = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0,sigma);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable sigma: ") + e.what());
        }

        if (!(context__.contains_r("L_rho")))
            throw std::runtime_error("variable L_rho missing");
        vals_r__ = context__.vals_r("L_rho");
        pos__ = 0U;
        validate_non_negative_index("L_rho", "2", 2);
        validate_non_negative_index("L_rho", "2", 2);
        context__.validate_dims("initialization", "L_rho", "matrix_d", context__.to_vec(2,2));
        // generate_declaration L_rho
        matrix_d L_rho(static_cast<Eigen::VectorXd::Index>(2),static_cast<Eigen::VectorXd::Index>(2));
        for (int j2__ = 0U; j2__ < 2; ++j2__)
            for (int j1__ = 0U; j1__ < 2; ++j1__)
                L_rho(j1__,j2__) = vals_r__[pos__++];
        try {
            writer__.cholesky_corr_unconstrain(L_rho);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable L_rho: ") + e.what());
        }

        if (!(context__.contains_r("z")))
            throw std::runtime_error("variable z missing");
        vals_r__ = context__.vals_r("z");
        pos__ = 0U;
        validate_non_negative_index("z", "2", 2);
        validate_non_negative_index("z", "n_record", n_record);
        context__.validate_dims("initialization", "z", "matrix_d", context__.to_vec(2,n_record));
        // generate_declaration z
        matrix_d z(static_cast<Eigen::VectorXd::Index>(2),static_cast<Eigen::VectorXd::Index>(n_record));
        for (int j2__ = 0U; j2__ < n_record; ++j2__)
            for (int j1__ = 0U; j1__ < 2; ++j1__)
                z(j1__,j2__) = vals_r__[pos__++];
        try {
            writer__.matrix_unconstrain(z);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable z: ") + e.what());
        }

        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }

    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }


    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(vector<T__>& params_r__,
                 vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {

        T__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;

        // model parameters
        stan::io::reader<T__> in__(params_r__,params_i__);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  v0_1;
        (void) v0_1;  // dummy to suppress unused var warning
        if (jacobian__)
            v0_1 = in__.vector_lub_constrain(0,2,n_record,lp__);
        else
            v0_1 = in__.vector_lub_constrain(0,2,n_record);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  sigma_record;
        (void) sigma_record;  // dummy to suppress unused var warning
        if (jacobian__)
            sigma_record = in__.vector_lb_constrain(0,2,lp__);
        else
            sigma_record = in__.vector_lb_constrain(0,2);

        T__ mu_kappa;
        (void) mu_kappa;  // dummy to suppress unused var warning
        if (jacobian__)
            mu_kappa = in__.scalar_lb_constrain(0,lp__);
        else
            mu_kappa = in__.scalar_lb_constrain(0);

        T__ mu_tempt;
        (void) mu_tempt;  // dummy to suppress unused var warning
        if (jacobian__)
            mu_tempt = in__.scalar_lb_constrain(0,lp__);
        else
            mu_tempt = in__.scalar_lb_constrain(0);

        T__ sigma;
        (void) sigma;  // dummy to suppress unused var warning
        if (jacobian__)
            sigma = in__.scalar_lb_constrain(0,lp__);
        else
            sigma = in__.scalar_lb_constrain(0);

        Eigen::Matrix<T__,Eigen::Dynamic,Eigen::Dynamic>  L_rho;
        (void) L_rho;  // dummy to suppress unused var warning
        if (jacobian__)
            L_rho = in__.cholesky_corr_constrain(2,lp__);
        else
            L_rho = in__.cholesky_corr_constrain(2);

        Eigen::Matrix<T__,Eigen::Dynamic,Eigen::Dynamic>  z;
        (void) z;  // dummy to suppress unused var warning
        if (jacobian__)
            z = in__.matrix_constrain(2,n_record,lp__);
        else
            z = in__.matrix_constrain(2,n_record);


        // transformed parameters
        validate_non_negative_index("cf", "n_record", n_record);
        validate_non_negative_index("cf", "2", 2);
        Eigen::Matrix<T__,Eigen::Dynamic,Eigen::Dynamic>  cf(static_cast<Eigen::VectorXd::Index>(n_record),static_cast<Eigen::VectorXd::Index>(2));
        (void) cf;  // dummy to suppress unused var warning

        stan::math::initialize(cf, DUMMY_VAR__);
        stan::math::fill(cf,DUMMY_VAR__);


        try {
            stan::math::assign(cf, transpose(multiply(diag_pre_multiply(sigma_record,L_rho),z)));
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed parameters
        for (int i0__ = 0; i0__ < n_record; ++i0__) {
            for (int i1__ = 0; i1__ < 2; ++i1__) {
                if (stan::math::is_uninitialized(cf(i0__,i1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: cf" << '[' << i0__ << ']' << '[' << i1__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }
        }

        const char* function__ = "validate transformed params";
        (void) function__;  // dummy to suppress unused var warning

        // model body
        try {
            {
                int rec(0);
                (void) rec;  // dummy to suppress unused var warning

                stan::math::fill(rec, std::numeric_limits<int>::min());
                T__ v0r;
                (void) v0r;  // dummy to suppress unused var warning

                stan::math::initialize(v0r, DUMMY_VAR__);
                stan::math::fill(v0r,DUMMY_VAR__);
                T__ kappar;
                (void) kappar;  // dummy to suppress unused var warning

                stan::math::initialize(kappar, DUMMY_VAR__);
                stan::math::fill(kappar,DUMMY_VAR__);
                T__ temptr;
                (void) temptr;  // dummy to suppress unused var warning

                stan::math::initialize(temptr, DUMMY_VAR__);
                stan::math::fill(temptr,DUMMY_VAR__);
                validate_non_negative_index("mu", "n", n);
                Eigen::Matrix<T__,Eigen::Dynamic,1>  mu(static_cast<Eigen::VectorXd::Index>(n));
                (void) mu;  // dummy to suppress unused var warning

                stan::math::initialize(mu, DUMMY_VAR__);
                stan::math::fill(mu,DUMMY_VAR__);


                lp_accum__.add(lkj_corr_cholesky_log<propto__>(L_rho, lkj));
                lp_accum__.add(normal_log<propto__>(to_vector(z), 0, 1));
                lp_accum__.add(normal_log<propto__>(v0_1, 1, 0.29999999999999999));
                lp_accum__.add(normal_log<propto__>(mu_kappa, 0.80000000000000004, 0.29999999999999999));
                lp_accum__.add(normal_log<propto__>(mu_tempt, 40, 20));
                lp_accum__.add(cauchy_log<propto__>(get_base1(sigma_record,1,"sigma_record",1), 0, 20));
                lp_accum__.add(cauchy_log<propto__>(get_base1(sigma_record,2,"sigma_record",1), 0, 0.40000000000000002));
                lp_accum__.add(cauchy_log<propto__>(sigma, 0.0, 0.20000000000000001));
                for (int i = 1; i <= n; ++i) {

                    stan::math::assign(rec, get_base1(record,i,"record",1));
                    stan::math::assign(v0r, get_base1(v0_1,rec,"v0_1",1));
                    stan::math::assign(temptr, (mu_tempt + get_base1(cf,rec,1,"cf",1)));
                    stan::math::assign(kappar, (mu_kappa + get_base1(cf,rec,2,"cf",1)));
                    stan::math::assign(get_base1_lhs(mu,i,"mu",1), ((v0r * (1 + ((kappar * get_base1(minute,i,"minute",1)) / temptr))) * exp((-(get_base1(minute,i,"minute",1)) / temptr))));
                }
                lp_accum__.add(student_t_log<propto__>(volume_1, student_df, mu, sigma));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        lp_accum__.add(lp__);
        return lp_accum__.sum();

    } // log_prob()

    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }


    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("v0_1");
        names__.push_back("sigma_record");
        names__.push_back("mu_kappa");
        names__.push_back("mu_tempt");
        names__.push_back("sigma");
        names__.push_back("L_rho");
        names__.push_back("z");
        names__.push_back("cf");
        names__.push_back("v0");
        names__.push_back("tempt");
        names__.push_back("kappa");
    }


    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(n_record);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(2);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(2);
        dims__.push_back(2);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(2);
        dims__.push_back(n_record);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n_record);
        dims__.push_back(2);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n_record);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n_record);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n_record);
        dimss__.push_back(dims__);
    }

    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        vars__.resize(0);
        stan::io::reader<double> in__(params_r__,params_i__);
        static const char* function__ = "model_linexp_gastro_2c_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        vector_d v0_1 = in__.vector_lub_constrain(0,2,n_record);
        vector_d sigma_record = in__.vector_lb_constrain(0,2);
        double mu_kappa = in__.scalar_lb_constrain(0);
        double mu_tempt = in__.scalar_lb_constrain(0);
        double sigma = in__.scalar_lb_constrain(0);
        matrix_d L_rho = in__.cholesky_corr_constrain(2);
        matrix_d z = in__.matrix_constrain(2,n_record);
        for (int k_0__ = 0; k_0__ < n_record; ++k_0__) {
            vars__.push_back(v0_1[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < 2; ++k_0__) {
            vars__.push_back(sigma_record[k_0__]);
        }
        vars__.push_back(mu_kappa);
        vars__.push_back(mu_tempt);
        vars__.push_back(sigma);
        for (int k_1__ = 0; k_1__ < 2; ++k_1__) {
            for (int k_0__ = 0; k_0__ < 2; ++k_0__) {
                vars__.push_back(L_rho(k_0__, k_1__));
            }
        }
        for (int k_1__ = 0; k_1__ < n_record; ++k_1__) {
            for (int k_0__ = 0; k_0__ < 2; ++k_0__) {
                vars__.push_back(z(k_0__, k_1__));
            }
        }

        if (!include_tparams__) return;
        // declare and define transformed parameters
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;

        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        validate_non_negative_index("cf", "n_record", n_record);
        validate_non_negative_index("cf", "2", 2);
        matrix_d cf(static_cast<Eigen::VectorXd::Index>(n_record),static_cast<Eigen::VectorXd::Index>(2));
        (void) cf;  // dummy to suppress unused var warning

        stan::math::initialize(cf, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(cf,DUMMY_VAR__);


        try {
            stan::math::assign(cf, transpose(multiply(diag_pre_multiply(sigma_record,L_rho),z)));
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed parameters

        // write transformed parameters
        for (int k_1__ = 0; k_1__ < 2; ++k_1__) {
            for (int k_0__ = 0; k_0__ < n_record; ++k_0__) {
                vars__.push_back(cf(k_0__, k_1__));
            }
        }

        if (!include_gqs__) return;
        // declare and define generated quantities
        validate_non_negative_index("v0", "n_record", n_record);
        vector_d v0(static_cast<Eigen::VectorXd::Index>(n_record));
        (void) v0;  // dummy to suppress unused var warning

        stan::math::initialize(v0, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(v0,DUMMY_VAR__);
        validate_non_negative_index("tempt", "n_record", n_record);
        vector_d tempt(static_cast<Eigen::VectorXd::Index>(n_record));
        (void) tempt;  // dummy to suppress unused var warning

        stan::math::initialize(tempt, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(tempt,DUMMY_VAR__);
        validate_non_negative_index("kappa", "n_record", n_record);
        vector_d kappa(static_cast<Eigen::VectorXd::Index>(n_record));
        (void) kappa;  // dummy to suppress unused var warning

        stan::math::initialize(kappa, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(kappa,DUMMY_VAR__);


        try {
            stan::math::assign(v0, multiply(v0_1,norm_vol));
            for (int i = 1; i <= n_record; ++i) {

                stan::math::assign(get_base1_lhs(tempt,i,"tempt",1), (mu_tempt + get_base1(cf,i,1,"cf",1)));
                stan::math::assign(get_base1_lhs(kappa,i,"kappa",1), (mu_kappa + get_base1(cf,i,2,"cf",1)));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate generated quantities

        // write generated quantities
        for (int k_0__ = 0; k_0__ < n_record; ++k_0__) {
            vars__.push_back(v0[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < n_record; ++k_0__) {
            vars__.push_back(tempt[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < n_record; ++k_0__) {
            vars__.push_back(kappa[k_0__]);
        }

    }

    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng,params_r_vec,params_i_vec,vars_vec,include_tparams,include_gqs,pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }

    static std::string model_name() {
        return "model_linexp_gastro_2c";
    }


    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= n_record; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "v0_1" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= 2; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma_record" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_kappa";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_tempt";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "sigma";
        param_names__.push_back(param_name_stream__.str());
        for (int k_1__ = 1; k_1__ <= 2; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= 2; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "L_rho" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_1__ = 1; k_1__ <= n_record; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= 2; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "z" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_1__ = 1; k_1__ <= 2; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= n_record; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "cf" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }

        if (!include_gqs__) return;
        for (int k_0__ = 1; k_0__ <= n_record; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "v0" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= n_record; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "tempt" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= n_record; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "kappa" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
    }


    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= n_record; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "v0_1" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= 2; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma_record" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_kappa";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_tempt";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "sigma";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= ((2 * (2 - 1)) / 2); ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "L_rho" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_1__ = 1; k_1__ <= n_record; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= 2; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "z" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_1__ = 1; k_1__ <= 2; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= n_record; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "cf" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }

        if (!include_gqs__) return;
        for (int k_0__ = 1; k_0__ <= n_record; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "v0" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= n_record; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "tempt" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= n_record; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "kappa" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
    }

}; // model

}




// Code generated by Stan version 2.15.0

#include <stan/model/model_header.hpp>

namespace model_powexp_gastro_1b_namespace {

using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;

typedef Eigen::Matrix<double,Eigen::Dynamic,1> vector_d;
typedef Eigen::Matrix<double,1,Eigen::Dynamic> row_vector_d;
typedef Eigen::Matrix<double,Eigen::Dynamic,Eigen::Dynamic> matrix_d;

static int current_statement_begin__;

class model_powexp_gastro_1b : public prob_grad {
private:
    double prior_v0;
    int n;
    int n_record;
    vector<int> record;
    vector_d minute;
    vector_d volume;
public:
    model_powexp_gastro_1b(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        typedef boost::ecuyer1988 rng_t;
        rng_t base_rng(0);  // 0 seed default
        ctor_body(context__, base_rng, pstream__);
    }

    template <class RNG>
    model_powexp_gastro_1b(stan::io::var_context& context__,
        RNG& base_rng__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, base_rng__, pstream__);
    }

    template <class RNG>
    void ctor_body(stan::io::var_context& context__,
                   RNG& base_rng__,
                   std::ostream* pstream__) {
        current_statement_begin__ = -1;

        static const char* function__ = "model_powexp_gastro_1b_namespace::model_powexp_gastro_1b";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        // initialize member variables
        context__.validate_dims("data initialization", "prior_v0", "double", context__.to_vec());
        prior_v0 = double(0);
        vals_r__ = context__.vals_r("prior_v0");
        pos__ = 0;
        prior_v0 = vals_r__[pos__++];
        context__.validate_dims("data initialization", "n", "int", context__.to_vec());
        n = int(0);
        vals_i__ = context__.vals_i("n");
        pos__ = 0;
        n = vals_i__[pos__++];
        context__.validate_dims("data initialization", "n_record", "int", context__.to_vec());
        n_record = int(0);
        vals_i__ = context__.vals_i("n_record");
        pos__ = 0;
        n_record = vals_i__[pos__++];
        validate_non_negative_index("record", "n", n);
        context__.validate_dims("data initialization", "record", "int", context__.to_vec(n));
        validate_non_negative_index("record", "n", n);
        record = std::vector<int>(n,int(0));
        vals_i__ = context__.vals_i("record");
        pos__ = 0;
        size_t record_limit_0__ = n;
        for (size_t i_0__ = 0; i_0__ < record_limit_0__; ++i_0__) {
            record[i_0__] = vals_i__[pos__++];
        }
        validate_non_negative_index("minute", "n", n);
        context__.validate_dims("data initialization", "minute", "vector_d", context__.to_vec(n));
        validate_non_negative_index("minute", "n", n);
        minute = vector_d(static_cast<Eigen::VectorXd::Index>(n));
        vals_r__ = context__.vals_r("minute");
        pos__ = 0;
        size_t minute_i_vec_lim__ = n;
        for (size_t i_vec__ = 0; i_vec__ < minute_i_vec_lim__; ++i_vec__) {
            minute[i_vec__] = vals_r__[pos__++];
        }
        validate_non_negative_index("volume", "n", n);
        context__.validate_dims("data initialization", "volume", "vector_d", context__.to_vec(n));
        validate_non_negative_index("volume", "n", n);
        volume = vector_d(static_cast<Eigen::VectorXd::Index>(n));
        vals_r__ = context__.vals_r("volume");
        pos__ = 0;
        size_t volume_i_vec_lim__ = n;
        for (size_t i_vec__ = 0; i_vec__ < volume_i_vec_lim__; ++i_vec__) {
            volume[i_vec__] = vals_r__[pos__++];
        }

        // validate, data variables
        check_greater_or_equal(function__,"n",n,0);
        check_greater_or_equal(function__,"n_record",n_record,0);
        // initialize data variables

        try {
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed data

        // validate, set parameter ranges
        num_params_r__ = 0U;
        param_ranges_i__.clear();
        validate_non_negative_index("v0", "n_record", n_record);
        num_params_r__ += n_record;
        validate_non_negative_index("beta", "n_record", n_record);
        num_params_r__ += n_record;
        validate_non_negative_index("tempt", "n_record", n_record);
        num_params_r__ += n_record;
        ++num_params_r__;
        ++num_params_r__;
        ++num_params_r__;
    }

    ~model_powexp_gastro_1b() { }


    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        stan::io::writer<double> writer__(params_r__,params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;

        if (!(context__.contains_r("v0")))
            throw std::runtime_error("variable v0 missing");
        vals_r__ = context__.vals_r("v0");
        pos__ = 0U;
        validate_non_negative_index("v0", "n_record", n_record);
        context__.validate_dims("initialization", "v0", "vector_d", context__.to_vec(n_record));
        // generate_declaration v0
        vector_d v0(static_cast<Eigen::VectorXd::Index>(n_record));
        for (int j1__ = 0U; j1__ < n_record; ++j1__)
            v0(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_lb_unconstrain(0,v0);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable v0: ") + e.what());
        }

        if (!(context__.contains_r("beta")))
            throw std::runtime_error("variable beta missing");
        vals_r__ = context__.vals_r("beta");
        pos__ = 0U;
        validate_non_negative_index("beta", "n_record", n_record);
        context__.validate_dims("initialization", "beta", "vector_d", context__.to_vec(n_record));
        // generate_declaration beta
        vector_d beta(static_cast<Eigen::VectorXd::Index>(n_record));
        for (int j1__ = 0U; j1__ < n_record; ++j1__)
            beta(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_lb_unconstrain(0,beta);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable beta: ") + e.what());
        }

        if (!(context__.contains_r("tempt")))
            throw std::runtime_error("variable tempt missing");
        vals_r__ = context__.vals_r("tempt");
        pos__ = 0U;
        validate_non_negative_index("tempt", "n_record", n_record);
        context__.validate_dims("initialization", "tempt", "vector_d", context__.to_vec(n_record));
        // generate_declaration tempt
        vector_d tempt(static_cast<Eigen::VectorXd::Index>(n_record));
        for (int j1__ = 0U; j1__ < n_record; ++j1__)
            tempt(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_lb_unconstrain(0,tempt);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable tempt: ") + e.what());
        }

        if (!(context__.contains_r("sigma")))
            throw std::runtime_error("variable sigma missing");
        vals_r__ = context__.vals_r("sigma");
        pos__ = 0U;
        context__.validate_dims("initialization", "sigma", "double", context__.to_vec());
        // generate_declaration sigma
        double sigma(0);
        sigma = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0,sigma);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable sigma: ") + e.what());
        }

        if (!(context__.contains_r("mu_beta")))
            throw std::runtime_error("variable mu_beta missing");
        vals_r__ = context__.vals_r("mu_beta");
        pos__ = 0U;
        context__.validate_dims("initialization", "mu_beta", "double", context__.to_vec());
        // generate_declaration mu_beta
        double mu_beta(0);
        mu_beta = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0,mu_beta);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable mu_beta: ") + e.what());
        }

        if (!(context__.contains_r("sigma_beta")))
            throw std::runtime_error("variable sigma_beta missing");
        vals_r__ = context__.vals_r("sigma_beta");
        pos__ = 0U;
        context__.validate_dims("initialization", "sigma_beta", "double", context__.to_vec());
        // generate_declaration sigma_beta
        double sigma_beta(0);
        sigma_beta = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0,sigma_beta);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable sigma_beta: ") + e.what());
        }

        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }

    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }


    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(vector<T__>& params_r__,
                 vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {

        T__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;

        // model parameters
        stan::io::reader<T__> in__(params_r__,params_i__);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  v0;
        (void) v0;  // dummy to suppress unused var warning
        if (jacobian__)
            v0 = in__.vector_lb_constrain(0,n_record,lp__);
        else
            v0 = in__.vector_lb_constrain(0,n_record);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  beta;
        (void) beta;  // dummy to suppress unused var warning
        if (jacobian__)
            beta = in__.vector_lb_constrain(0,n_record,lp__);
        else
            beta = in__.vector_lb_constrain(0,n_record);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  tempt;
        (void) tempt;  // dummy to suppress unused var warning
        if (jacobian__)
            tempt = in__.vector_lb_constrain(0,n_record,lp__);
        else
            tempt = in__.vector_lb_constrain(0,n_record);

        T__ sigma;
        (void) sigma;  // dummy to suppress unused var warning
        if (jacobian__)
            sigma = in__.scalar_lb_constrain(0,lp__);
        else
            sigma = in__.scalar_lb_constrain(0);

        T__ mu_beta;
        (void) mu_beta;  // dummy to suppress unused var warning
        if (jacobian__)
            mu_beta = in__.scalar_lb_constrain(0,lp__);
        else
            mu_beta = in__.scalar_lb_constrain(0);

        T__ sigma_beta;
        (void) sigma_beta;  // dummy to suppress unused var warning
        if (jacobian__)
            sigma_beta = in__.scalar_lb_constrain(0,lp__);
        else
            sigma_beta = in__.scalar_lb_constrain(0);


        // transformed parameters


        try {
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed parameters

        const char* function__ = "validate transformed params";
        (void) function__;  // dummy to suppress unused var warning

        // model body
        try {
            {
                int reci(0);
                (void) reci;  // dummy to suppress unused var warning

                stan::math::fill(reci, std::numeric_limits<int>::min());
                T__ v0r;
                (void) v0r;  // dummy to suppress unused var warning

                stan::math::initialize(v0r, DUMMY_VAR__);
                stan::math::fill(v0r,DUMMY_VAR__);
                T__ betar;
                (void) betar;  // dummy to suppress unused var warning

                stan::math::initialize(betar, DUMMY_VAR__);
                stan::math::fill(betar,DUMMY_VAR__);
                T__ temptr;
                (void) temptr;  // dummy to suppress unused var warning

                stan::math::initialize(temptr, DUMMY_VAR__);
                stan::math::fill(temptr,DUMMY_VAR__);
                validate_non_negative_index("vol", "n", n);
                vector<T__> vol(n);
                stan::math::initialize(vol, DUMMY_VAR__);
                stan::math::fill(vol,DUMMY_VAR__);


                lp_accum__.add(normal_log<propto__>(mu_beta, 1.5, 0.5));
                lp_accum__.add(normal_log<propto__>(sigma_beta, 1, 0.5));
                lp_accum__.add(normal_log<propto__>(v0, prior_v0, 100));
                lp_accum__.add(lognormal_log<propto__>(beta, mu_beta, sigma_beta));
                lp_accum__.add(normal_log<propto__>(tempt, 60, 20));
                lp_accum__.add(gamma_log<propto__>(sigma, 20, 0.5));
                for (int i = 1; i <= n; ++i) {

                    stan::math::assign(reci, get_base1(record,i,"record",1));
                    stan::math::assign(v0r, get_base1(v0,reci,"v0",1));
                    stan::math::assign(betar, get_base1(beta,reci,"beta",1));
                    stan::math::assign(temptr, get_base1(tempt,reci,"tempt",1));
                    stan::math::assign(get_base1_lhs(vol,i,"vol",1), (v0r * exp(-(pow((get_base1(minute,i,"minute",1) / temptr),betar)))));
                }
                lp_accum__.add(normal_log<propto__>(volume, vol, sigma));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        lp_accum__.add(lp__);
        return lp_accum__.sum();

    } // log_prob()

    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }


    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("v0");
        names__.push_back("beta");
        names__.push_back("tempt");
        names__.push_back("sigma");
        names__.push_back("mu_beta");
        names__.push_back("sigma_beta");
    }


    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(n_record);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n_record);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n_record);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
    }

    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        vars__.resize(0);
        stan::io::reader<double> in__(params_r__,params_i__);
        static const char* function__ = "model_powexp_gastro_1b_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        vector_d v0 = in__.vector_lb_constrain(0,n_record);
        vector_d beta = in__.vector_lb_constrain(0,n_record);
        vector_d tempt = in__.vector_lb_constrain(0,n_record);
        double sigma = in__.scalar_lb_constrain(0);
        double mu_beta = in__.scalar_lb_constrain(0);
        double sigma_beta = in__.scalar_lb_constrain(0);
        for (int k_0__ = 0; k_0__ < n_record; ++k_0__) {
            vars__.push_back(v0[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < n_record; ++k_0__) {
            vars__.push_back(beta[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < n_record; ++k_0__) {
            vars__.push_back(tempt[k_0__]);
        }
        vars__.push_back(sigma);
        vars__.push_back(mu_beta);
        vars__.push_back(sigma_beta);

        if (!include_tparams__) return;
        // declare and define transformed parameters
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;

        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning



        try {
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed parameters

        // write transformed parameters

        if (!include_gqs__) return;
        // declare and define generated quantities


        try {
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate generated quantities

        // write generated quantities
    }

    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng,params_r_vec,params_i_vec,vars_vec,include_tparams,include_gqs,pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }

    static std::string model_name() {
        return "model_powexp_gastro_1b";
    }


    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= n_record; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "v0" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= n_record; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= n_record; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "tempt" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "sigma";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_beta";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "sigma_beta";
        param_names__.push_back(param_name_stream__.str());

        if (!include_gqs__ && !include_tparams__) return;

        if (!include_gqs__) return;
    }


    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= n_record; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "v0" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= n_record; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= n_record; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "tempt" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "sigma";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_beta";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "sigma_beta";
        param_names__.push_back(param_name_stream__.str());

        if (!include_gqs__ && !include_tparams__) return;

        if (!include_gqs__) return;
    }

}; // model

}




// Code generated by Stan version 2.15.0

#include <stan/model/model_header.hpp>

namespace model_powexp_gastro_2c_namespace {

using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;

typedef Eigen::Matrix<double,Eigen::Dynamic,1> vector_d;
typedef Eigen::Matrix<double,1,Eigen::Dynamic> row_vector_d;
typedef Eigen::Matrix<double,Eigen::Dynamic,Eigen::Dynamic> matrix_d;

static int current_statement_begin__;

class model_powexp_gastro_2c : public prob_grad {
private:
    double lkj;
    int student_df;
    int n;
    int n_record;
    vector<int> record;
    vector_d minute;
    vector_d volume;
    vector_d zeros;
    vector_d volume_1;
    double norm_vol;
    int n_norm;
public:
    model_powexp_gastro_2c(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        typedef boost::ecuyer1988 rng_t;
        rng_t base_rng(0);  // 0 seed default
        ctor_body(context__, base_rng, pstream__);
    }

    template <class RNG>
    model_powexp_gastro_2c(stan::io::var_context& context__,
        RNG& base_rng__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, base_rng__, pstream__);
    }

    template <class RNG>
    void ctor_body(stan::io::var_context& context__,
                   RNG& base_rng__,
                   std::ostream* pstream__) {
        current_statement_begin__ = -1;

        static const char* function__ = "model_powexp_gastro_2c_namespace::model_powexp_gastro_2c";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        // initialize member variables
        context__.validate_dims("data initialization", "lkj", "double", context__.to_vec());
        lkj = double(0);
        vals_r__ = context__.vals_r("lkj");
        pos__ = 0;
        lkj = vals_r__[pos__++];
        context__.validate_dims("data initialization", "student_df", "int", context__.to_vec());
        student_df = int(0);
        vals_i__ = context__.vals_i("student_df");
        pos__ = 0;
        student_df = vals_i__[pos__++];
        context__.validate_dims("data initialization", "n", "int", context__.to_vec());
        n = int(0);
        vals_i__ = context__.vals_i("n");
        pos__ = 0;
        n = vals_i__[pos__++];
        context__.validate_dims("data initialization", "n_record", "int", context__.to_vec());
        n_record = int(0);
        vals_i__ = context__.vals_i("n_record");
        pos__ = 0;
        n_record = vals_i__[pos__++];
        validate_non_negative_index("record", "n", n);
        context__.validate_dims("data initialization", "record", "int", context__.to_vec(n));
        validate_non_negative_index("record", "n", n);
        record = std::vector<int>(n,int(0));
        vals_i__ = context__.vals_i("record");
        pos__ = 0;
        size_t record_limit_0__ = n;
        for (size_t i_0__ = 0; i_0__ < record_limit_0__; ++i_0__) {
            record[i_0__] = vals_i__[pos__++];
        }
        validate_non_negative_index("minute", "n", n);
        context__.validate_dims("data initialization", "minute", "vector_d", context__.to_vec(n));
        validate_non_negative_index("minute", "n", n);
        minute = vector_d(static_cast<Eigen::VectorXd::Index>(n));
        vals_r__ = context__.vals_r("minute");
        pos__ = 0;
        size_t minute_i_vec_lim__ = n;
        for (size_t i_vec__ = 0; i_vec__ < minute_i_vec_lim__; ++i_vec__) {
            minute[i_vec__] = vals_r__[pos__++];
        }
        validate_non_negative_index("volume", "n", n);
        context__.validate_dims("data initialization", "volume", "vector_d", context__.to_vec(n));
        validate_non_negative_index("volume", "n", n);
        volume = vector_d(static_cast<Eigen::VectorXd::Index>(n));
        vals_r__ = context__.vals_r("volume");
        pos__ = 0;
        size_t volume_i_vec_lim__ = n;
        for (size_t i_vec__ = 0; i_vec__ < volume_i_vec_lim__; ++i_vec__) {
            volume[i_vec__] = vals_r__[pos__++];
        }

        // validate, data variables
        check_greater_or_equal(function__,"n",n,0);
        check_greater_or_equal(function__,"n_record",n_record,0);
        // initialize data variables
        validate_non_negative_index("zeros", "2", 2);
        zeros = vector_d(static_cast<Eigen::VectorXd::Index>(2));
        stan::math::fill(zeros,DUMMY_VAR__);
        validate_non_negative_index("volume_1", "n", n);
        volume_1 = vector_d(static_cast<Eigen::VectorXd::Index>(n));
        stan::math::fill(volume_1,DUMMY_VAR__);
        norm_vol = double(0);
        stan::math::fill(norm_vol,DUMMY_VAR__);
        n_norm = int(0);
        stan::math::fill(n_norm, std::numeric_limits<int>::min());

        try {
            stan::math::assign(get_base1_lhs(zeros,1,"zeros",1), 0);
            stan::math::assign(get_base1_lhs(zeros,2,"zeros",1), 0);
            stan::math::assign(n_norm, 0);
            stan::math::assign(norm_vol, 0);
            for (int i = 1; i <= n; ++i) {

                if (as_bool(logical_lt(get_base1(minute,i,"minute",1),5))) {

                    stan::math::assign(norm_vol, (norm_vol + get_base1(volume,i,"volume",1)));
                    stan::math::assign(n_norm, (n_norm + 1));
                }
            }
            stan::math::assign(norm_vol, (norm_vol / n_norm));
            stan::math::assign(volume_1, divide(volume,norm_vol));
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed data

        // validate, set parameter ranges
        num_params_r__ = 0U;
        param_ranges_i__.clear();
        validate_non_negative_index("v0_1", "n_record", n_record);
        num_params_r__ += n_record;
        validate_non_negative_index("sigma_record", "2", 2);
        num_params_r__ += 2;
        ++num_params_r__;
        ++num_params_r__;
        ++num_params_r__;
        validate_non_negative_index("L_rho", "2", 2);
        num_params_r__ += ((2 * (2 - 1)) / 2);
        validate_non_negative_index("z", "2", 2);
        validate_non_negative_index("z", "n_record", n_record);
        num_params_r__ += 2 * n_record;
    }

    ~model_powexp_gastro_2c() { }


    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        stan::io::writer<double> writer__(params_r__,params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;

        if (!(context__.contains_r("v0_1")))
            throw std::runtime_error("variable v0_1 missing");
        vals_r__ = context__.vals_r("v0_1");
        pos__ = 0U;
        validate_non_negative_index("v0_1", "n_record", n_record);
        context__.validate_dims("initialization", "v0_1", "vector_d", context__.to_vec(n_record));
        // generate_declaration v0_1
        vector_d v0_1(static_cast<Eigen::VectorXd::Index>(n_record));
        for (int j1__ = 0U; j1__ < n_record; ++j1__)
            v0_1(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_lub_unconstrain(0,2,v0_1);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable v0_1: ") + e.what());
        }

        if (!(context__.contains_r("sigma_record")))
            throw std::runtime_error("variable sigma_record missing");
        vals_r__ = context__.vals_r("sigma_record");
        pos__ = 0U;
        validate_non_negative_index("sigma_record", "2", 2);
        context__.validate_dims("initialization", "sigma_record", "vector_d", context__.to_vec(2));
        // generate_declaration sigma_record
        vector_d sigma_record(static_cast<Eigen::VectorXd::Index>(2));
        for (int j1__ = 0U; j1__ < 2; ++j1__)
            sigma_record(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_lb_unconstrain(0,sigma_record);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable sigma_record: ") + e.what());
        }

        if (!(context__.contains_r("mu_beta")))
            throw std::runtime_error("variable mu_beta missing");
        vals_r__ = context__.vals_r("mu_beta");
        pos__ = 0U;
        context__.validate_dims("initialization", "mu_beta", "double", context__.to_vec());
        // generate_declaration mu_beta
        double mu_beta(0);
        mu_beta = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0,mu_beta);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable mu_beta: ") + e.what());
        }

        if (!(context__.contains_r("mu_tempt")))
            throw std::runtime_error("variable mu_tempt missing");
        vals_r__ = context__.vals_r("mu_tempt");
        pos__ = 0U;
        context__.validate_dims("initialization", "mu_tempt", "double", context__.to_vec());
        // generate_declaration mu_tempt
        double mu_tempt(0);
        mu_tempt = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0,mu_tempt);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable mu_tempt: ") + e.what());
        }

        if (!(context__.contains_r("sigma")))
            throw std::runtime_error("variable sigma missing");
        vals_r__ = context__.vals_r("sigma");
        pos__ = 0U;
        context__.validate_dims("initialization", "sigma", "double", context__.to_vec());
        // generate_declaration sigma
        double sigma(0);
        sigma = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0,sigma);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable sigma: ") + e.what());
        }

        if (!(context__.contains_r("L_rho")))
            throw std::runtime_error("variable L_rho missing");
        vals_r__ = context__.vals_r("L_rho");
        pos__ = 0U;
        validate_non_negative_index("L_rho", "2", 2);
        validate_non_negative_index("L_rho", "2", 2);
        context__.validate_dims("initialization", "L_rho", "matrix_d", context__.to_vec(2,2));
        // generate_declaration L_rho
        matrix_d L_rho(static_cast<Eigen::VectorXd::Index>(2),static_cast<Eigen::VectorXd::Index>(2));
        for (int j2__ = 0U; j2__ < 2; ++j2__)
            for (int j1__ = 0U; j1__ < 2; ++j1__)
                L_rho(j1__,j2__) = vals_r__[pos__++];
        try {
            writer__.cholesky_corr_unconstrain(L_rho);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable L_rho: ") + e.what());
        }

        if (!(context__.contains_r("z")))
            throw std::runtime_error("variable z missing");
        vals_r__ = context__.vals_r("z");
        pos__ = 0U;
        validate_non_negative_index("z", "2", 2);
        validate_non_negative_index("z", "n_record", n_record);
        context__.validate_dims("initialization", "z", "matrix_d", context__.to_vec(2,n_record));
        // generate_declaration z
        matrix_d z(static_cast<Eigen::VectorXd::Index>(2),static_cast<Eigen::VectorXd::Index>(n_record));
        for (int j2__ = 0U; j2__ < n_record; ++j2__)
            for (int j1__ = 0U; j1__ < 2; ++j1__)
                z(j1__,j2__) = vals_r__[pos__++];
        try {
            writer__.matrix_unconstrain(z);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable z: ") + e.what());
        }

        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }

    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }


    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(vector<T__>& params_r__,
                 vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {

        T__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;

        // model parameters
        stan::io::reader<T__> in__(params_r__,params_i__);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  v0_1;
        (void) v0_1;  // dummy to suppress unused var warning
        if (jacobian__)
            v0_1 = in__.vector_lub_constrain(0,2,n_record,lp__);
        else
            v0_1 = in__.vector_lub_constrain(0,2,n_record);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  sigma_record;
        (void) sigma_record;  // dummy to suppress unused var warning
        if (jacobian__)
            sigma_record = in__.vector_lb_constrain(0,2,lp__);
        else
            sigma_record = in__.vector_lb_constrain(0,2);

        T__ mu_beta;
        (void) mu_beta;  // dummy to suppress unused var warning
        if (jacobian__)
            mu_beta = in__.scalar_lb_constrain(0,lp__);
        else
            mu_beta = in__.scalar_lb_constrain(0);

        T__ mu_tempt;
        (void) mu_tempt;  // dummy to suppress unused var warning
        if (jacobian__)
            mu_tempt = in__.scalar_lb_constrain(0,lp__);
        else
            mu_tempt = in__.scalar_lb_constrain(0);

        T__ sigma;
        (void) sigma;  // dummy to suppress unused var warning
        if (jacobian__)
            sigma = in__.scalar_lb_constrain(0,lp__);
        else
            sigma = in__.scalar_lb_constrain(0);

        Eigen::Matrix<T__,Eigen::Dynamic,Eigen::Dynamic>  L_rho;
        (void) L_rho;  // dummy to suppress unused var warning
        if (jacobian__)
            L_rho = in__.cholesky_corr_constrain(2,lp__);
        else
            L_rho = in__.cholesky_corr_constrain(2);

        Eigen::Matrix<T__,Eigen::Dynamic,Eigen::Dynamic>  z;
        (void) z;  // dummy to suppress unused var warning
        if (jacobian__)
            z = in__.matrix_constrain(2,n_record,lp__);
        else
            z = in__.matrix_constrain(2,n_record);


        // transformed parameters
        validate_non_negative_index("cf", "n_record", n_record);
        validate_non_negative_index("cf", "2", 2);
        Eigen::Matrix<T__,Eigen::Dynamic,Eigen::Dynamic>  cf(static_cast<Eigen::VectorXd::Index>(n_record),static_cast<Eigen::VectorXd::Index>(2));
        (void) cf;  // dummy to suppress unused var warning

        stan::math::initialize(cf, DUMMY_VAR__);
        stan::math::fill(cf,DUMMY_VAR__);


        try {
            stan::math::assign(cf, transpose(multiply(diag_pre_multiply(sigma_record,L_rho),z)));
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed parameters
        for (int i0__ = 0; i0__ < n_record; ++i0__) {
            for (int i1__ = 0; i1__ < 2; ++i1__) {
                if (stan::math::is_uninitialized(cf(i0__,i1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: cf" << '[' << i0__ << ']' << '[' << i1__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }
        }

        const char* function__ = "validate transformed params";
        (void) function__;  // dummy to suppress unused var warning

        // model body
        try {
            {
                int rec(0);
                (void) rec;  // dummy to suppress unused var warning

                stan::math::fill(rec, std::numeric_limits<int>::min());
                T__ v0r;
                (void) v0r;  // dummy to suppress unused var warning

                stan::math::initialize(v0r, DUMMY_VAR__);
                stan::math::fill(v0r,DUMMY_VAR__);
                T__ betar;
                (void) betar;  // dummy to suppress unused var warning

                stan::math::initialize(betar, DUMMY_VAR__);
                stan::math::fill(betar,DUMMY_VAR__);
                T__ temptr;
                (void) temptr;  // dummy to suppress unused var warning

                stan::math::initialize(temptr, DUMMY_VAR__);
                stan::math::fill(temptr,DUMMY_VAR__);
                validate_non_negative_index("mu", "n", n);
                Eigen::Matrix<T__,Eigen::Dynamic,1>  mu(static_cast<Eigen::VectorXd::Index>(n));
                (void) mu;  // dummy to suppress unused var warning

                stan::math::initialize(mu, DUMMY_VAR__);
                stan::math::fill(mu,DUMMY_VAR__);


                lp_accum__.add(lkj_corr_cholesky_log<propto__>(L_rho, lkj));
                lp_accum__.add(normal_log<propto__>(to_vector(z), 0, 1));
                lp_accum__.add(normal_log<propto__>(v0_1, 1, 0.29999999999999999));
                lp_accum__.add(normal_log<propto__>(mu_beta, 1.2, 0.5));
                lp_accum__.add(normal_log<propto__>(mu_tempt, 100, 50));
                lp_accum__.add(cauchy_log<propto__>(get_base1(sigma_record,1,"sigma_record",1), 0, 20));
                lp_accum__.add(cauchy_log<propto__>(get_base1(sigma_record,2,"sigma_record",1), 0, 0.40000000000000002));
                lp_accum__.add(cauchy_log<propto__>(sigma, 0.0, 0.5));
                for (int i = 1; i <= n; ++i) {

                    stan::math::assign(rec, get_base1(record,i,"record",1));
                    stan::math::assign(v0r, get_base1(v0_1,rec,"v0_1",1));
                    stan::math::assign(temptr, (mu_tempt + get_base1(cf,rec,1,"cf",1)));
                    stan::math::assign(betar, (mu_beta + get_base1(cf,rec,2,"cf",1)));
                    stan::math::assign(get_base1_lhs(mu,i,"mu",1), (v0r * exp(-(pow((get_base1(minute,i,"minute",1) / temptr),betar)))));
                }
                lp_accum__.add(student_t_log<propto__>(volume_1, student_df, mu, sigma));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        lp_accum__.add(lp__);
        return lp_accum__.sum();

    } // log_prob()

    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }


    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("v0_1");
        names__.push_back("sigma_record");
        names__.push_back("mu_beta");
        names__.push_back("mu_tempt");
        names__.push_back("sigma");
        names__.push_back("L_rho");
        names__.push_back("z");
        names__.push_back("cf");
        names__.push_back("v0");
        names__.push_back("tempt");
        names__.push_back("beta");
    }


    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(n_record);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(2);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(2);
        dims__.push_back(2);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(2);
        dims__.push_back(n_record);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n_record);
        dims__.push_back(2);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n_record);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n_record);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n_record);
        dimss__.push_back(dims__);
    }

    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        vars__.resize(0);
        stan::io::reader<double> in__(params_r__,params_i__);
        static const char* function__ = "model_powexp_gastro_2c_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        vector_d v0_1 = in__.vector_lub_constrain(0,2,n_record);
        vector_d sigma_record = in__.vector_lb_constrain(0,2);
        double mu_beta = in__.scalar_lb_constrain(0);
        double mu_tempt = in__.scalar_lb_constrain(0);
        double sigma = in__.scalar_lb_constrain(0);
        matrix_d L_rho = in__.cholesky_corr_constrain(2);
        matrix_d z = in__.matrix_constrain(2,n_record);
        for (int k_0__ = 0; k_0__ < n_record; ++k_0__) {
            vars__.push_back(v0_1[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < 2; ++k_0__) {
            vars__.push_back(sigma_record[k_0__]);
        }
        vars__.push_back(mu_beta);
        vars__.push_back(mu_tempt);
        vars__.push_back(sigma);
        for (int k_1__ = 0; k_1__ < 2; ++k_1__) {
            for (int k_0__ = 0; k_0__ < 2; ++k_0__) {
                vars__.push_back(L_rho(k_0__, k_1__));
            }
        }
        for (int k_1__ = 0; k_1__ < n_record; ++k_1__) {
            for (int k_0__ = 0; k_0__ < 2; ++k_0__) {
                vars__.push_back(z(k_0__, k_1__));
            }
        }

        if (!include_tparams__) return;
        // declare and define transformed parameters
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;

        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        validate_non_negative_index("cf", "n_record", n_record);
        validate_non_negative_index("cf", "2", 2);
        matrix_d cf(static_cast<Eigen::VectorXd::Index>(n_record),static_cast<Eigen::VectorXd::Index>(2));
        (void) cf;  // dummy to suppress unused var warning

        stan::math::initialize(cf, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(cf,DUMMY_VAR__);


        try {
            stan::math::assign(cf, transpose(multiply(diag_pre_multiply(sigma_record,L_rho),z)));
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed parameters

        // write transformed parameters
        for (int k_1__ = 0; k_1__ < 2; ++k_1__) {
            for (int k_0__ = 0; k_0__ < n_record; ++k_0__) {
                vars__.push_back(cf(k_0__, k_1__));
            }
        }

        if (!include_gqs__) return;
        // declare and define generated quantities
        validate_non_negative_index("v0", "n_record", n_record);
        vector_d v0(static_cast<Eigen::VectorXd::Index>(n_record));
        (void) v0;  // dummy to suppress unused var warning

        stan::math::initialize(v0, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(v0,DUMMY_VAR__);
        validate_non_negative_index("tempt", "n_record", n_record);
        vector_d tempt(static_cast<Eigen::VectorXd::Index>(n_record));
        (void) tempt;  // dummy to suppress unused var warning

        stan::math::initialize(tempt, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(tempt,DUMMY_VAR__);
        validate_non_negative_index("beta", "n_record", n_record);
        vector_d beta(static_cast<Eigen::VectorXd::Index>(n_record));
        (void) beta;  // dummy to suppress unused var warning

        stan::math::initialize(beta, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(beta,DUMMY_VAR__);


        try {
            stan::math::assign(v0, multiply(v0_1,norm_vol));
            for (int i = 1; i <= n_record; ++i) {

                stan::math::assign(get_base1_lhs(tempt,i,"tempt",1), (mu_tempt + get_base1(cf,i,1,"cf",1)));
                stan::math::assign(get_base1_lhs(beta,i,"beta",1), (mu_beta + get_base1(cf,i,2,"cf",1)));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate generated quantities

        // write generated quantities
        for (int k_0__ = 0; k_0__ < n_record; ++k_0__) {
            vars__.push_back(v0[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < n_record; ++k_0__) {
            vars__.push_back(tempt[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < n_record; ++k_0__) {
            vars__.push_back(beta[k_0__]);
        }

    }

    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng,params_r_vec,params_i_vec,vars_vec,include_tparams,include_gqs,pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }

    static std::string model_name() {
        return "model_powexp_gastro_2c";
    }


    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= n_record; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "v0_1" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= 2; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma_record" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_beta";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_tempt";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "sigma";
        param_names__.push_back(param_name_stream__.str());
        for (int k_1__ = 1; k_1__ <= 2; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= 2; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "L_rho" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_1__ = 1; k_1__ <= n_record; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= 2; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "z" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_1__ = 1; k_1__ <= 2; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= n_record; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "cf" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }

        if (!include_gqs__) return;
        for (int k_0__ = 1; k_0__ <= n_record; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "v0" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= n_record; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "tempt" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= n_record; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
    }


    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= n_record; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "v0_1" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= 2; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma_record" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_beta";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_tempt";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "sigma";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= ((2 * (2 - 1)) / 2); ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "L_rho" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_1__ = 1; k_1__ <= n_record; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= 2; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "z" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_1__ = 1; k_1__ <= 2; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= n_record; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "cf" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }

        if (!include_gqs__) return;
        for (int k_0__ = 1; k_0__ <= n_record; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "v0" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= n_record; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "tempt" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= n_record; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
    }

}; // model

}




#endif
