% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_6400.R
\name{read_6400_txt}
\alias{read_6400_txt}
\title{Reads 6400XT text files and creates a tibble with gas-exchange data}
\usage{
read_6400_txt(filename, tz = Sys.timezone())
}
\arguments{
\item{filename}{an text file containing 6400XT gas-exchange data.}

\item{tz}{a character string specifying the timezone for the loaded file. If
omitted, the current time zone is used. Invalid values are typically
treated as UTC, on some platforms with a warning.}
}
\value{
A tibble with gas-exchange data in columns.
}
\description{
The text files stored by the 6400 contain measured and calculated values that
are read by this function and formatted in a large tibble for use with R.
Constants and metadata are also added as columns. Note that no recalculation
of derived variables is performed, although it is possible to so using
\code{\link[=recalculate]{recalculate()}} after importing the data.
}
\details{
Multiple files can be loaded by calling the function with \code{\link[=lapply]{lapply()}} or
\code{\link[purrr:map]{purrr::map()}} to merge multiple files. In this case, it is important
to ensure that the column names will match.
}
\examples{
example <- system.file("extdata//6400-testfile", package = "gasanalyzer")

# read data
li6400data <- read_6400_txt(example)

#View
li6400data

}
\seealso{
recalculate
}
