% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{read.ctable}
\alias{read.ctable}
\title{Read a complex table and return array in basic storagemode.}
\usage{
read.ctable(file, header, row.names, col.names, ...,
  storagemode = "double")
}
\arguments{
\item{file}{The name of the file to be read in, see ('file' in ?read.table).}

\item{header}{hierarchy structure of the header, a list of length 2,
assigning the index of row and col header,
affecting parsing of the input table;}

\item{row.names, col.names}{a list, whose elements can be
a character vector assigning the name of one dimension directly, or
a integer scalar which is the index ({icol,irow}) of {row,col}-header
that will be extracted; since the row and the col headers can have
hierarchy in the input table and the hierarchy will be organized into
addisional dimensions, rownames indicate the names of dimensions that
are from the row of the input table, while colnames, the col; in the
input table, the header can be in two pattern: AAA and AOO;
in the AAA pattern, the names are repeated for the cells that are in
the same index in high dimension, while in the AOO pattern, the names
appear once at the first and the other cells that are in the same index
in high dimension are left blank; in the
output array, {row,col}.names are not necessary \code{dimnames[[1]]} and
\code{dimnames[[2]]};
if all elements of the list are a integer scalar, then the list can
also be coded as a integer vector (since they are the same for lapply);}

\item{...}{Further arguments to be passed to ‘read.table’.}

\item{storagemode}{The storagemode of return matrix, usually 'double'.}
}
\description{
A complex table has
several row and colume headers, some of which indicate the hierarchy
of the dimensions (thus the returned array may have more dimensions than
row and column), some of which are real row.names and
col.names that will be turn into dimnames, and some of which are
additional attributes.  Cells of non-header are all in a same format
(like double).  The original header are preserved as attributes.
The dimnames strictly save the layout of the matrix, thus row.names
and col.names should be carefully chosen for matching the actual
dimension.  Sometime aperm() is needed after this function.
Sparse table, where dimnames is not complete (unbalanced) and needs
non-fractionally recycling, is not supported.
}
