% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gargle-package.R, R/utils-ui.R
\name{gargle_options}
\alias{gargle_options}
\alias{gargle_oauth_email}
\alias{gargle_oob_default}
\alias{gargle_oauth_cache}
\alias{gargle_oauth_client_type}
\alias{gargle_verbosity}
\alias{local_gargle_verbosity}
\alias{with_gargle_verbosity}
\title{Options consulted by gargle}
\usage{
gargle_oauth_email()

gargle_oob_default()

gargle_oauth_cache()

gargle_oauth_client_type()

gargle_verbosity()

local_gargle_verbosity(level, env = parent.frame())

with_gargle_verbosity(level, code)
}
\arguments{
\item{level}{Verbosity level: "debug" > "info" > "silent"}

\item{env}{The environment to use for scoping}

\item{code}{Code to execute with specified verbosity level}
}
\description{
Wrapper functions around options consulted by gargle, which provide:
\itemize{
\item A place to hang documentation.
\item The mechanism for setting a default.
}

If the built-in defaults don't suit you, set one or more of these options.
Typically, this is done in the \code{.Rprofile} startup file, with code along
these lines:

\if{html}{\out{<div class="sourceCode">}}\preformatted{options(
  gargle_oauth_email = "jane@example.com",
  gargle_oauth_cache = "/path/to/folder/that/does/not/sync/to/cloud"
)
}\if{html}{\out{</div>}}
}
\section{\code{gargle_oauth_email}}{

\code{gargle_oauth_email()} returns the option named "gargle_oauth_email", which
is undefined by default. If set, this option should be one of:
\itemize{
\item An actual email address corresponding to your preferred Google identity.
Example:\code{janedoe@gmail.com}.
\item A glob pattern that indicates your preferred Google domain.
Example:\verb{*@example.com}.
\item \code{TRUE} to allow email and OAuth token auto-discovery, if exactly one
suitable token is found in the cache.
\item \code{FALSE} or \code{NA} to force the OAuth dance in the browser.
}
}

\section{\code{gargle_oob_default}}{

\code{gargle_oob_default()} returns \code{TRUE} unconditionally on RStudio Server,
Posit Workbench, Posit Cloud, or Google Colaboratory, since it is not
possible to launch a local web server in these contexts. In this case, for
the final step of the OAuth dance, the user is redirected to a specific URL
where they must copy a code and paste it back into the R session.

In all other contexts, \code{gargle_oob_default()} consults the option named
\code{"gargle_oob_default"}, then the option named \code{"httr_oob_default"}, and
eventually defaults to \code{FALSE}.

"oob" stands for out-of-band. Read more about out-of-band authentication in
the vignette \code{vignette("auth-from-web")}.
}

\section{\code{gargle_oauth_cache}}{

\code{gargle_oauth_cache()} returns the option named "gargle_oauth_cache",
defaulting to \code{NA}. If defined, the option must be set to a logical value or
a string. \code{TRUE} means to cache using the default user-level cache file,
\verb{~/.R/gargle/gargle-oauth}, \code{FALSE} means don't cache, and \code{NA} means to
guess using some sensible heuristics.
}

\section{\code{gargle_oauth_client_type}}{

\code{gargle_oauth_client_type()} returns the option named
"gargle_oauth_client_type", if defined. If defined, the option must be either
"installed" or "web". If the option is not defined, the function returns:
\itemize{
\item "web" on RStudio Server, Posit Workbench, Posit Cloud, or Google
Colaboratory
\item "installed" otherwise
}

Primarily intended to help infer the most suitable OAuth client type when a
user is relying on a built-in client, such as the tidyverse client used by
packages like bigrquery, googledrive, and googlesheets4.
}

\section{\code{gargle_verbosity}}{

\code{gargle_verbosity()} returns the option named "gargle_verbosity", which
determines gargle's verbosity. There are three possible values, inspired by
the logging levels of log4j:
\itemize{
\item "debug": Fine-grained information helpful when debugging, e.g. figuring out
how \code{token_fetch()} is working through the registry of credential
functions. Previously, this was activated by setting an option named
"gargle_quiet" to \code{FALSE}.
\item "info" (default): High-level information that a typical user needs to see.
Since typical gargle usage is always indirect, i.e. gargle is called by
another package, gargle itself is very quiet. There are very few messages
emitted when \code{gargle_verbosity = "info"}.
\item "silent": No messages at all. However, warnings or errors are still thrown
normally.
}
}

\examples{
gargle_oauth_email()
gargle_oob_default()
gargle_oauth_cache()
gargle_oauth_client_type()
gargle_verbosity()
}
