% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parsnip-garch_multivariate_reg.R
\name{garch_multivariate_reg}
\alias{garch_multivariate_reg}
\title{General Interface for Multivariate GARCH Models}
\usage{
garch_multivariate_reg(mode = "regression", type = NULL)
}
\arguments{
\item{mode}{A single character string for the type of model (Only regression is supported).}

\item{type}{A single character string for the type of model or specification (See details below).

Other options and argument can be set using \code{set_engine()} (See Engine Details below).}
}
\value{
A model specfication
}
\description{
\code{garch_multivariate_reg()} allows you to model the volatility of various time series. This can be done with the multivariate equivalent
of the univariate GARCH model. Estimating multivariate GARCH models turns out to be significantly more difficult than univariate GARCH models,
but this function facilitates the task through different engines such as rugarch, dcc_rmgarch, gogar_rmgarch etc.
}
\details{
Available engines:
\itemize{
\item \strong{rugarch (default)}: Connects to \code{rugarch::multispec()} and \code{rugarch::multifit()}
\item \strong{dcc_rmgarch}: Connects to \code{rugarch::multispec()}, \code{rugarch::multifit()}, \code{rmgarch::dccspec()} and \code{rmgarch::dccfit()}.
\item \strong{c_rmgarch}: Connects to \code{rugarch::multispec()}, \code{rugarch::multifit()}, \code{rmgarch::cgarchspec()} and \code{rmgarch::cgarchfit()}.
\item \strong{gogarch_rmgarch}: Connects to \code{rmgarch::gogarchspec()} and \code{rmgarch::gogarchspec()}.
}
}
\section{Engine Details}{


\strong{rugarch (default)}

The engine uses \code{\link[rugarch:multispec-methods]{rugarch::multispec()}} and then \code{\link[rugarch:multifit-methods]{rugarch::multifit()}}

\strong{Main Arguments}
\itemize{
\item \code{type}: You can choose between \code{ugarchspec} (default) or \code{arfimaspec}. Depending on which one you choose,
you will select either a univariate GARCH model for each of your variables or an Arfima model as specification,
which will then be passed to \code{rugarch::multispec()}.
}

You \strong{must} pass an argument through \code{set_engine()} called \strong{specs} which will
be a list consisting of the arguments to be passed to each of the specifications used
in \code{rugarch::multispec()}. Other arguments that you wish to pass to \code{rugarch::multifit()} can
also be passed through \code{set_engine()}

For example, imagine you have a data frame with 3 variables. For each of those variables you must
define a specification (you can check the arguments you can use for a specification in ?rugarch::ugarchspec).
Once the specifications have been decided, the way to pass it through set_engine would be as follows:

garch_multivariate_reg(mode = "regression") \%>\%
set_engine("rugarch" , specs = list(spec1 = list(mean.model = list(armaOrder = c(1,0))),
spec2 = list(mean.model = list(armaOrder = c(1,0))),
spec3 = list(mean.model = list(armaOrder = c(1,0)))),
out.sample = 10)

In the fit section we will see how to pass variables through parsnip::fit (See Fit Section below).

Parameter Notes:
\itemize{
\item \code{xreg} - This engine does support xregs, but you have to provide them to each model in an
array through set_engine. For more information see ?rugarch::ugarchspec. The xregs can be provided
through \code{variance.model$external.regressors} or \code{mean.model$external.regressors} (or both) for the
specifications of the desired variables.
}

\strong{dcc_rmgarch}

The engine uses \code{\link[rugarch:multispec-methods]{rugarch::multispec()}}, \code{\link[rugarch:multifit-methods]{rugarch::multifit()}}, \code{\link[rmgarch:dccspec-methods]{rmgarch::dccspec()}} and \code{\link[rmgarch:dccfit-methods]{rmgarch::dccfit()}}.

\strong{Main Arguments}
\itemize{
\item \code{type}: Only \code{ugarchspec} is supported for this engine. This will then be passed to \code{rugarch::multispec()}.
}

You \strong{must} pass an argument through \code{set_engine()} called \strong{specs} which will
be a list consisting of the arguments to be passed to each of the specifications used
in \code{rugarch::multispec()}. Other arguments that you wish to pass to \code{rugarch::multifit()} can
also be passed through \code{set_engine()}. To pass arguments to \code{dccfit()} you \strong{must} pass a list through
\code{set_engine} called \strong{dcc_specs}.

For example, imagine you have a data frame with 3 variables. For each of those variables you must
define a specification (you can check the arguments you can use for a specification in ?rugarch::ugarchspec).
Once the specifications have been decided, the way to pass it through set_engine would be as follows:

garch_fit_model <- garch_multivariate_reg(type = "ugarchspec") \%>\%
set_engine("dcc_rmgarch" , specs = list(spec1 = list(mean.model = list(armaOrder = c(1,0))),
spec2 = list(mean.model = list(armaOrder = c(1,0))),
spec3 = list(mean.model = list(armaOrder = c(1,0)))),
dcc_specs = list(dccOrder = c(2,2), distribution = "mvlaplace"))

In the fit section we will see how to pass variables through parsnip::fit (See Fit Section below).

\strong{c_rmgarch}

The engine uses \code{\link[rugarch:multispec-methods]{rugarch::multispec()}}, \code{\link[rugarch:multifit-methods]{rugarch::multifit()}}, \code{\link[rmgarch:cgarchspec-methods]{rmgarch::cgarchspec()}} and \code{\link[rmgarch:cgarchfit-methods]{rmgarch::cgarchfit()}}.

\strong{Main Arguments}
\itemize{
\item \code{type}: Only \code{ugarchspec} is supported for this engine. This will then be passed to \code{rugarch::multispec()}.
}

You \strong{must} pass an argument through \code{set_engine()} called \strong{specs} which will
be a list consisting of the arguments to be passed to each of the specifications used
in \code{rugarch::multispec()}. Other arguments that you wish to pass to \code{rugarch::multifit()} can
also be passed through \code{set_engine()}. To pass arguments to \code{cgarchfit()} you \strong{must} pass a list through
\code{set_engine} called \strong{c_specs}.

For example, imagine you have a data frame with 3 variables. For each of those variables you must
define a specification (you can check the arguments you can use for a specification in ?rugarch::ugarchspec).
Once the specifications have been decided, the way to pass it through set_engine would be as follows:

garch_fit_model <- garch_multivariate_reg(type = "arfima") \%>\%
set_engine("c_rmgarch" , specs = list(spec1 = list(mean.model = list(armaOrder = c(1,0))),
spec2 = list(mean.model = list(armaOrder = c(1,0))),
spec3 = list(mean.model = list(armaOrder = c(1,0)))),
c_specs = list(dccOrder = c(2,2))) \%>\%
fit(value ~ date + id, data = rX_longer_train)

In the fit section we will see how to pass variables through parsnip::fit (See Fit Section below).

\strong{gogarch_rmgarch}

The engine uses \code{\link[rmgarch:gogarchspec-methods]{rmgarch::gogarchspec()}} and \code{\link[rmgarch:gogarchfit-methods]{rmgarch::gogarchfit()}}.

\strong{Main Arguments}
\itemize{
\item \code{type}: Not available for this engine.
}

You \strong{must} pass an argument through \code{set_engine()} called \strong{gogarch_specs} which will
be a list consisting of the arguments to be passed to each of the specifications used
in \code{rmgarch::gogarchspec()}. Other arguments that you wish to pass to \code{rmgarch::gogarchfit()} can
also be passed through \code{set_engine()}.

For example, imagine you have a data frame with 3 variables. For each of those variables you must
define a specification (you can check the arguments you can use for a specification in ?rugarch::ugarchspec).
Once the specifications have been decided, the way to pass it through set_engine would be as follows:

model_fit_garch <- garch_multivariate_reg(type = "ugarchspec") \%>\%
set_engine("gogarch_rmgarch" , gogarch_specs = list(variance.model = list(garchOrder = c(2,2)))) \%>\%
fit(value ~ date + id, data = rX_longer_train)

In the fit section we will see how to pass variables through parsnip::fit (See Fit Section below).
}

\examples{
\donttest{
library(tidymodels)
library(garchmodels)
library(modeltime)
library(tidyverse)
library(timetk)
library(lubridate)

rX_longer <-  rX_longer \%>\%
    dplyr::mutate(date = as.Date(date)) \%>\%
    group_by(id) \%>\%
    future_frame(.length_out = 3, .bind_data = TRUE) \%>\%
    ungroup()

rX_longer_train  <- rX_longer \%>\% drop_na()
rX_longer_future <- rX_longer \%>\% filter(is.na(value))

#RUGARCH ENGINE

model_fit_garch <- garch_multivariate_reg() \%>\%
    set_engine("rugarch" , specs = list(spec1 = list(mean.model = list(armaOrder = c(1,0))), 
                                        spec2 = list(mean.model = list(armaOrder = c(1,0))),
                                        spec3 = list(mean.model = list(armaOrder = c(1,0))))) \%>\%
    fit(value ~ date + id, data = rX_longer_train)

predict(model_fit_garch, new_data = rX_longer_future)


#DCC ENGINE

 model_fit_garch <- garch_multivariate_reg(type = "ugarchspec") \%>\%
set_engine("dcc_rmgarch" , specs = list(spec1 = list(mean.model = list(armaOrder = c(1,0))), 
                                        spec2 = list(mean.model = list(armaOrder = c(1,0))),
                                        spec3 = list(mean.model = list(armaOrder = c(1,0)))),
           dcc_specs = list(dccOrder = c(2,2), distribution = "mvlaplace")) \%>\%
    fit(value ~ date + id, data = rX_longer_train)

predict(model_fit_garch, rX_longer_future) 


# COPULA ENGINE

model_fit_garch <- garch_multivariate_reg(type = "ugarchspec") \%>\%
set_engine("c_rmgarch" , specs = list(spec1 = list(mean.model = list(armaOrder = c(1,0))),
                                      spec2 = list(mean.model = list(armaOrder = c(1,0))),
                                      spec3 = list(mean.model = list(armaOrder = c(1,0)))),
           c_specs = list(dccOrder = c(2,2))) \%>\%
    fit(value ~ date + id, data = rX_longer_train)


# GO-GARCH ENGINE

model_fit_garch <- garch_multivariate_reg(type = "ugarchspec") \%>\%
set_engine("gogarch_rmgarch" , gogarch_specs = list(variance.model = list(garchOrder = c(2,2)))) \%>\%
    fit(value ~ date + id, data = rX_longer_train)
    
predict(model_fit_garch, rX_longer_future)
}
}
\seealso{
\code{\link[=fit.model_spec]{fit.model_spec()}}, \code{\link[=set_engine]{set_engine()}}
}
