% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gapfill.R
\name{ArrayAround}
\alias{ArrayAround}
\alias{ArrayAroundRandom}
\title{Subset an Array with 4 dimensions}
\usage{
ArrayAround(data, mp, size)

ArrayAroundRandom(
  data,
  size = c(0L, 0L, 0L, 0L),
  target = c("all", "missing", "observed"),
  verbose = TRUE
)
}
\arguments{
\item{data}{Array with 4 dimensions.}

\item{mp}{Integer vector of length 4
indexing an element in \code{data}.}

\item{size}{Integer vector of length 4, that provides
the size of the subset in all four dimensions
(around \code{mp}).}

\item{target}{One of 
\code{c("all", "missing", "observed")}.
Indicates from which subset of \code{data} a random
location is sampled.}

\item{verbose}{Logical vector of length 1.
If \code{TRUE}, messages are printed.}
}
\value{
Array with 4 dimensions corresponding to the specified subset.
The attribute \code{mp} of the returned array is an integer vector
of length 4 giving \code{mp} relative to the
returned array.
}
\description{
Given an array \code{data} with 4 dimensions,
a subset around the element with coordinates \code{mp} ("missing position") is extracted.
The size of the subset in all four directions
from \code{mp} is specified by \code{size}. \cr
\code{ArrayAroundRandom} returns a subset around a
random location in \code{data}.
}
\note{
When \code{size = c(0, 0, 0, 0)}, the returned subset consists of one value
(the value of \code{data} indexed with \code{mp}.) \cr
When \code{mp} is near the boundaries of \code{data},
the returned subset may be smaller than indicated by the argument \code{size}
and the attribute \code{mp} may indicate an element near the boundaries of the subset.
}
\examples{
a <- array(1:16, c(2, 2, 2, 2))
ArrayAround(data = a, mp = c(1, 1, 1, 1), size = c(0, 0, 0, 0))
## returns the first element a[1,1,1,1]

ArrayAround(data = a, mp = c(2, 2, 2, 2), size = c(0, 0, 0, 0))
## returns the last element a[2,2,2,2]

ArrayAround(data = a, mp = c(1, 1, 1, 1), size = c(1, 0, 0, 0))
## returns a[1:2,1,1,1]

ArrayAround(data = a, mp = c(1, 1, 1, 1), size = c(1, 1, 1, 1))
## returns a


ArrayAroundRandom(a)
ArrayAroundRandom(a, size = c(1, 2, 1, 2))
}
\author{
Florian Gerber, \email{flora.fauna.gerber@gmail.com}.
}
