% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gapfill.R
\name{Image}
\alias{Image}
\title{Image Panels}
\usage{
Image(x = NULL, zlim = range(x, na.rm = TRUE),
  col = fields::tim.colors(1000), na.value = "black", byrow = TRUE,
  xlab = "", ylab = "", colbarTitle = "", ...)
}
\arguments{
\item{x}{Numeric array with 4, 3, or 2 dimensions
containing the data to be plotted.}

\item{zlim}{Numeric vector of length 2.
Gives the upper and lower bound of the plotted values.}

\item{col}{Vector of colors.}

\item{na.value}{Vector of length one.
The color to be used for NA values.}

\item{byrow}{Logical vector of length one.
Indicates the ordering of the panels.}

\item{xlab}{Character vector (or expression) of length one giving the x-axis label.}

\item{ylab}{Character vector (or expression) of length one giving the y-axis label.}

\item{colbarTitle}{Character vector (or expression) of length one giving the colorbar label.}

\item{...}{Additional arguments are passed to \code{ggplot}.}
}
\value{
Object (plot) of class \code{c("gg", "ggplot2")}.
}
\description{
Creates an image panel to visualize data in 4, 3 or 2 dimensional arrays (e.g., space-time data). 
The function returns a \code{ggplot2} object, which 
can be modified using ggplot2 (and/or grid) syntax.
}
\examples{
Image(ndvi)

p1 <- Image(ndvi, colbarTitle = "NDVI", byrow  = FALSE)
p1

p2 <- Image(ndvi[,,3,2], na.value = "white", colbarTitle = "NDVI") +
      theme(strip.text.x = element_blank(),
            strip.text.y = element_blank(),
            panel.border = element_rect(fill = NA, size = 1))
p2

## place modified color bar left
p2 + guides(fill = guide_colorbar(title = "NDVI", 
                                  barwidth = 1,
                                  barheight = 20,
                                  label.position = "left", 
                                  legend.position = c(0, 0))) +
     theme(legend.position = "left")

## place color bar at bottom
p2 + guides(fill = guide_colorbar(title = "NDVI", 
                                  barwidth = 7,
                                  barheight = .7,
                                  label.position = "bottom", 
                                  legend.position = c(0, 0)),
                                  direction = "horizontal") +
     theme(legend.position = "bottom")

}
\author{
Florian Gerber, \email{florian.gerber@math.uzh.ch}.
}
\seealso{
\code{\link{ndvi}}, \code{\link[ggplot2]{ggplot}}.
}

