% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cis.vs.trans.classification.R
\name{cis.vs.trans.classification}
\alias{cis.vs.trans.classification}
\title{A cis/trans classifier}
\usage{
cis.vs.trans.classification(hits, panel, id, radius = 1e+06)
}
\arguments{
\item{hits}{Data to be used, which contains prot, Chr, bp, id and/or other information such as SNPid.}

\item{panel}{Panel data.}

\item{id}{Identifier.}

\item{radius}{The flanking distance for variants.}
}
\value{
The cis/trans classification.
}
\description{
The function classifies variants into cis/trans category according to a panel which contains id, chr, start, end, gene variables.
}
\examples{
cis.vs.trans.classification(hits=jma.cojo, panel=inf1, id="uniprot")
\dontrun{
INF <- Sys.getenv("INF")
f <- file.path(INF,"work","INF1.merge")
clumped <- read.delim(f,as.is=TRUE)
hits <- merge(clumped[c("CHR","POS","MarkerName","prot","log10p")],
              inf1[c("prot","uniprot")],by="prot")
names(hits) <- c("prot","Chr","bp","SNP","log10p","uniprot")
cistrans <- cis.vs.trans.classification(hits,inf1,"uniprot")
cis.vs.trans <- with(cistrans,data)
knitr::kable(with(cistrans,table),caption="Table 1. cis/trans classification")
with(cistrans,total)
}
}
\author{
James Peters
}
