% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Segment-generics.R, R/Segment-methods.R
\docType{methods}
\name{PerUser}
\alias{PerUser}
\alias{PerUser,ANY-method}
\alias{PerUser,gaMetExpr-method}
\alias{PerUser,formula-method}
\title{PerUser.}
\usage{
PerUser(object, ..., negation)

\S4method{PerUser}{ANY}(object, ..., negation)

\S4method{PerUser}{gaMetExpr}(object, ..., negation)

\S4method{PerUser}{formula}(object, ..., negation)
}
\arguments{
\item{object}{a .gaSegmentFilter or gaMetExpr object to coerce to
user-level. Alternatively, an dimension expression or segment filter to
coerce into a user scoped gaDynSegment.}

\item{...}{Other filters to include in the gaDynSegment.}

\item{negation}{boolean value indicating whether to negate the condition.}
}
\value{
a gaMetExpr, .gaSegmentFilter or gaDynSegment.

  To define a gaDynSegment comprised of a single metric expression,
  wrap the metric expression in an \code{Include} or \code{Exclude} call.
}
\description{
Set the scope of a .gaSegmentFilter or gaMetExpr object to user-level.
}
\section{Methods (by class)}{
\itemize{
\item \code{ANY}: Create a user-level segment filter list from the supplied
expressions, each interpreted as an include segment filter.

\item \code{gaMetExpr}: Set the scope of the supplied metric condition to
user-level.

\item \code{formula}: Set the scope of the supplied non-standard-evaluation
metric condition to user-level.
}}

