% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/peaks_search.R
\docType{methods}
\name{peaks_search}
\alias{peaks_search}
\alias{peaks_search-method}
\alias{peaks_search,GammaSpectrum,integer-method}
\alias{peaks_search,GammaSpectrum,numeric-method}
\title{Search Peaks}
\usage{
peaks_search(object, index, ...)

\S4method{peaks_search}{GammaSpectrum,integer}(object, index, span = 10, tolerance = 0.025)

\S4method{peaks_search}{GammaSpectrum,numeric}(object, index, span = 10, tolerance = 0.025)
}
\arguments{
\item{object}{A \linkS4class{GammaSpectrum} object.}

\item{index}{A vector giving the expected peak position.
If \code{index} is a \code{\link{numeric}} vector, peaks are searched by energy (\code{index} is
assumed to be expressed in keV). If \code{index} is an \code{\link{integer}} vector, peaks
are searched by channel.}

\item{...}{Currently not used.}

\item{span}{A \code{\link{numeric}} value giving the half window size for searching.
If \code{index} is a \code{\link{numeric}} vector, \code{span} is expressed in keV.
If \code{index} is an \code{\link{integer}} vector, \code{span} is expressed in channel.}

\item{tolerance}{A \code{\link{numeric}} value giving the threshold above which a
warning/error is raised.}
}
\value{
A \linkS4class{PeakPosition} object.
}
\description{
Search the maxima in sequential data around a given value.
}
\examples{
## Import a LaBr spectrum
LaBr_file <- system.file("extdata/LaBr.TKA", package = "gamma")
LaBr_spc <- read(LaBr_file)

## Find peaks by channel
(LaBr_pks <- peaks_find(LaBr_spc)) # Ugly
plot(LaBr_spc, LaBr_pks)

## Search peaks by channel
(LaBr_pks <- peaks_search(LaBr_spc, index = c(86L, 207L, 496L), span = 7))
plot(LaBr_spc, LaBr_pks, split = TRUE)

## Import a BEGe spectrum
BEGe_file <- system.file("extdata/BEGe.CNF", package = "gamma")
BEGe_spc <- read(BEGe_file)

## Search peaks by energy
(BEGe_pks <- peaks_search(BEGe_spc, index = c(47, 63, 911, 1460)))
plot(BEGe_spc, BEGe_pks, split = TRUE)
}
\seealso{
Other signal processing: 
\code{\link{baseline}},
\code{\link{peaks_find}()},
\code{\link{signal_integrate}()},
\code{\link{signal_slice}()},
\code{\link{signal_split}()},
\code{\link{signal_stabilize}()},
\code{\link{smooth}()}
}
\author{
N. Frerebeau
}
\concept{signal processing}
