% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprecated_functions.R
\name{deprecated}
\alias{deprecated}
\alias{select_taxa}
\alias{select_columns}
\alias{select_filters}
\alias{select_locations}
\alias{ala_occurrences}
\alias{ala_counts}
\alias{ala_species}
\alias{ala_taxonomy}
\alias{ala_media}
\alias{ala_citation}
\alias{find_reasons}
\alias{find_cached_files}
\alias{find_ranks}
\alias{find_profiles}
\alias{find_atlases}
\alias{ala_config}
\alias{search_field_values}
\alias{search_profile_attributes}
\title{Deprecated functions}
\usage{
select_taxa(query, is_id = FALSE)

select_columns(..., group)

select_filters(..., profile = NULL)

select_locations(query)

ala_occurrences(
  taxa = NULL,
  filters = NULL,
  locations = NULL,
  columns = select_columns(group = "basic"),
  mint_doi = FALSE,
  doi = NULL,
  refresh_cache = FALSE
)

ala_counts(
  taxa = NULL,
  filters = NULL,
  locations = NULL,
  limit = 100,
  type = c("record", "species"),
  refresh_cache = FALSE
)

ala_species(
  taxa = NULL,
  filters = NULL,
  locations = NULL,
  refresh_cache = FALSE
)

ala_taxonomy(taxa, down_to)

ala_media(
  taxa = NULL,
  filters = NULL,
  locations = NULL,
  columns = select_columns(group = "basic"),
  download_dir,
  refresh_cache = FALSE
)

ala_citation(data)

find_reasons()

find_cached_files()

find_ranks()

find_profiles()

find_atlases()

ala_config(..., profile_path = NULL)

search_field_values(field)

search_profile_attributes(profile)
}
\arguments{
\item{query}{A vector of taxonomic names (for \code{select_taxa()}) or a valid
well-known text string (for \code{select_locations()}).}

\item{is_id}{Logical: Does the information provided in \code{query} consist of
taxonomic identifiers (TRUE), or taxonomic names (FALSE, the default).}

\item{...}{Queries consisting of field names (for \code{select_columns()}) or
equations (for \code{select_filters()}).}

\item{group}{optional; the name of a group of columns to include. See
\code{galah_select()} for details.}

\item{profile}{String: The name of a valid ALA profile.}

\item{taxa}{A tibble created with \code{galah_identify()}}

\item{filters}{A tibble created with \code{galah_filter()}}

\item{locations}{A tibble created with \code{galah_geolocate()}}

\item{columns}{A tibble created with \code{galah_select()}}

\item{mint_doi}{Logical: Should a DOI be created for this download? Defaults
to FALSE.}

\item{doi}{String: Optional ALA DOI to download}

\item{refresh_cache}{Logical: Should the data be re-downloaded to the cache?
Defaults to FALSE.}

\item{limit}{Integer: How many records should be downloaded? Defaults to 100.}

\item{type}{String: Should counts be made of the number of \code{"records"}
(default) or \code{"species"}?}

\item{down_to}{A tibble created with \code{galah_down_to()}}

\item{download_dir}{Path to a directory in which to place media files}

\item{data}{A tibble returned by \code{ala_occurrences()}}

\item{profile_path}{Optional path to profile information}

\item{field}{String: A valid field for which to display entries.}
}
\value{
All deprecated functions return a \code{tibble}.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

Use \code{\link[=galah_identify]{galah_identify()}} instead of \code{select_taxa()}.

Use \code{\link[=galah_select]{galah_select()}} instead of \code{select_columns()}.

Use \code{\link[=galah_filter]{galah_filter()}} instead of \code{select_filters()}.

Use \code{\link[=galah_geolocate]{galah_geolocate()}} instead of \code{select_locations()}.

Use \code{\link[=atlas_occurrences]{atlas_occurrences()}} instead of \code{ala_occurrences()}.

Use \code{\link[=atlas_counts]{atlas_counts()}} instead of \code{ala_counts()}.

Use \code{\link[=atlas_species]{atlas_species()}} instead of \code{ala_species()}.

Use \code{\link[=atlas_taxonomy]{atlas_taxonomy()}} instead of \code{ala_taxonomy()}.

Use \code{\link[=atlas_media]{atlas_media()}} instead of \code{ala_media()}.

Use \code{\link[=atlas_citation]{atlas_citation()}} instead of \code{ala_citation()}.

Use \code{\link[=show_all_reasons]{show_all_reasons()}} instead of \code{find_reasons()}.

Use \code{\link[=show_all_cached_files]{show_all_cached_files()}} instead of \code{find_cached_files()}.

Use \code{\link[=show_all_ranks]{show_all_ranks()}} instead of \code{find_ranks()}.

Use \code{\link[=show_all_profiles]{show_all_profiles()}} instead of \code{find_profiles()}.

Use \code{\link[=show_all_atlases]{show_all_atlases()}} instead of \code{find_atlases()}.

Use \code{\link[=galah_config]{galah_config()}} instead of \code{ala_config()}.

Use \code{\link[=show_values]{show_values()}} instead of \code{search_field_values()}

Use \code{\link[=show_values]{show_values()}} instead of \code{search_profile_attributes()}
}
\keyword{internal}
