% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ciTest-array.R
\name{citest-array}
\alias{citest-array}
\alias{ciTest_table}
\title{Test for conditional independence in a contingency table}
\usage{
ciTest_table(
  x,
  set = NULL,
  statistic = "dev",
  method = "chisq",
  adjust.df = TRUE,
  slice.info = TRUE,
  L = 20,
  B = 200,
  ...
)
}
\arguments{
\item{x}{An array of counts with named dimnames.}

\item{set}{A specification of the test to be made. The tests are of the form u
and v are independent condionally on S where u and v are variables and S
is a set of variables. See 'details' for details about specification of
\code{set}.}

\item{statistic}{Possible choices of the test statistic are \code{"dev"} for
deviance and \code{"X2"} for Pearsons X2 statistic.}

\item{method}{Method of evaluating the test statistic. Possible choices are
\code{"chisq"}, \code{"mc"} (for Monte Carlo) and \code{"smc"} for
sequential Monte Carlo.}

\item{adjust.df}{Logical. Should degrees of freedom be adjusted for
sparsity?}

\item{slice.info}{Logical. Should slice info be stored in the
output?}

\item{L}{Number of extreme cases as stop criterion if method is
\code{"smc"} (sequential Monte Carlo test); ignored otherwise.}

\item{B}{Number (maximum) of simulations to make if method is
\code{"mc"} or \code{"smc"} (Monte Carlo test or sequential
Monte Carlo test); ignored otherwise.}

\item{...}{Additional arguments.}
}
\value{
An object of class \code{citest} (which is a list).
}
\description{
Test for conditional independence in a contingency table
represented as an array.
}
\details{
\code{set} can be 1) a vector or 2) a right-hand sided formula in
which variables are separated by '+'. In either case, it is tested if the
first two variables in the \code{set} are conditionally independent given
the remaining variables in \code{set}.  (Notice an abuse of the '+'
operator in the right-hand sided formula: The order of the variables does
matter.)

If \code{set} is \code{NULL} then it is tested whether the first two
variables are conditionally independent given the remaining variables.
}
\examples{

data(lizard)

## lizard is has named dimnames
names( dimnames( lizard ))
## checked with
is.named.array( lizard )

## Testing for conditional independence:
# the following are all equivalent:
ciTest(lizard, set=~diam + height + species)
# ciTest(lizard, set=c("diam", "height", "species"))
# ciTest(lizard, set=1:3)
# ciTest(lizard)
# (The latter because the names in lizard are as given above.)

## Testing for marginal independence
ciTest(lizard, set=~diam + height)
ciTest(lizard, set=1:2)

## Getting slice information:
ciTest(lizard, set=c("diam", "height", "species"), slice.info=TRUE)$slice

## Do Monte Carlo test instead of usual likelihood ratio test. Different
# options:

# 1) Do B*10 simulations divided equally over each slice: 
ciTest(lizard, set=c("diam", "height", "species"), method="mc", B=400)
# 2) Do at most B*10 simulations divided equally over each slice, but stop
# when at most L extreme values are found
ciTest(lizard, set=c("diam", "height", "species"), method="smc", B=400)
}
\seealso{
\code{\link{ciTest}}, \code{\link{ciTest_df}},
\code{\link{ciTest_mvn}}, \code{\link{chisq.test}}
}
\author{
Søren Højsgaard, \email{sorenh@math.aau.dk}
}
\keyword{htest}
