% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph-topoSort.R
\name{graph-toposort}
\alias{graph-toposort}
\alias{topo_sort}
\alias{topo_sortMAT}
\alias{topoSort}
\alias{topoSortMAT}
\title{Topological sort of vertices in directed acyclic graph}
\usage{
topo_sort(object, index = FALSE)

topo_sortMAT(amat, index = FALSE)

topoSort(object, index = FALSE)

topoSortMAT(amat, index = FALSE)
}
\arguments{
\item{object}{An graph represented either as a \code{graphNEL}
object, an \code{igraph}, a (dense) \code{matrix}, a (sparse)
\code{dgCMatrix}.}

\item{index}{If FALSE, an ordering is returned if it exists and
\code{character(0)} otherwise. If TRUE, the index of the
variables in an adjacency matrix is returned and \code{-1}
otherwise.}

\item{amat}{Adjacency matrix.}
}
\value{
If FALSE, an ordering is returned if it exists and
\code{character(0)} otherwise. If TRUE, the index of the
variables in an adjacency matrix is returned and \code{-1}
otherwise.
}
\description{
A topological ordering of a directed graph is a linear
ordering of its vertices such that, for every edge (u->v), u
comes before v in the ordering.  A topological ordering is
possible if and only if the graph has no directed cycles, that
is, if it is a directed acyclic graph (DAG). Any DAG has at
least one topological ordering. Can hence be used for checking
if a graph is a DAG.
}
\note{
The workhorse is the \code{topo_sortMAT} function which takes
an adjacency matrix as input.
}
\section{Synonymous functions}{


The functions \code{topo_sort} / \code{topoSort} are synonymous with \code{topo_sortMAT} /
\code{topoSortMAT}. One of the groups may be deprecated in the future.
}

\examples{
dagMAT  <- dag(~a:b:c + c:d:e, result="matrix")
dagMATS <- as(dagMAT, "dgCMatrix")
dagNEL  <- as(dagMAT, "graphNEL")

topo_sort(dagMAT)
topo_sort(dagMATS)
topo_sort(dagNEL)
}
\seealso{
\code{\link{dag}}, \code{\link{ug}}
}
\author{
Søren Højsgaard, \email{sorenh@math.aau.dk}
}
\keyword{utilities}
