% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/t_array_misc.R
\name{df2xtabs}
\alias{df2xtabs}
\title{Convert dataframe to contingency table}
\usage{
df2xtabs(indata, names = NULL, normalize = "none", smooth = 0)
}
\arguments{
\item{indata}{A dataframe.}

\item{names}{Names of variables defining table; a character vector
or a right hand sided formula.}

\item{normalize}{Either "none", "first" or "all". Should result be
normalized, see 'Details' below.}

\item{smooth}{Should values be smoothed, see 'Details' below.}
}
\description{
: Much like xtabs but with more flexibility
}
\examples{
## Extract arrays from dataframe (much like xtabs() but with more flexibility)
data(cad1) 
df2xtabs(cad1, ~Sex:AngPec:AMI)
df2xtabs(cad1, c("Sex", "AngPec", "AMI"))
df2xtabs(cad1, c(1, 2, 3))
}
