% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/querygrain.R
\name{querygrain}
\alias{querygrain}
\alias{querygrain.grain}
\alias{qgrain}
\title{Query a network}
\usage{
querygrain(
  object,
  nodes = nodeNames(object),
  type = "marginal",
  evidence = NULL,
  exclude = TRUE,
  normalize = TRUE,
  result = "array",
  details = 0
)
}
\arguments{
\item{object}{A \code{grain} object.}

\item{nodes}{A vector of nodes; those nodes for which the
(conditional) distribution is requested.}

\item{type}{Valid choices are \code{"marginal"} which gives the
marginal distribution for each node in \code{nodes};
\code{"joint"} which gives the joint distribution for
\code{nodes} and \code{"conditional"} which gives the
conditional distribution for the first variable in \code{nodes}
given the other variables in \code{nodes}.}

\item{evidence}{An alternative way of specifying findings
(evidence), see examples below.}

\item{exclude}{If \code{TRUE} then nodes on which evidence is given
will be excluded from \code{nodes} (see above).}

\item{normalize}{Should the results be normalized to sum to one.}

\item{result}{If "data.frame" the result is returned as a data
frame (or possibly as a list of dataframes).}

\item{details}{Debugging information}
}
\value{
A list of tables with potentials.
}
\description{
Query an independence network, i.e. obtain the
conditional distribution of a set of variables - possibly (and
typically) given finding (evidence) on other variables.
}
\note{
\code{setEvidence()} is an improvement of \code{setFinding()}
(and as such \code{setFinding} is obsolete). Users are
recommended to use \code{setEvidence()} in the future.

\code{setEvidence()} allows to specification of "hard evidence" (specific
values for variables) and likelihood evidence (also known as virtual
evidence) for variables.

The syntax of \code{setEvidence()} may change in the future.
}
\examples{

testfile <- system.file("huginex", "chest_clinic.net", package = "gRain")
chest <- loadHuginNet(testfile, details=0)
qb <- querygrain(chest)
qb

lapply(qb, as.numeric) # Safe
sapply(qb, as.numeric) # Risky

}
\references{
Søren Højsgaard (2012). Graphical Independence Networks
with the gRain Package for R. Journal of Statistical Software,
46(10), 1-26.  \url{http://www.jstatsoft.org/v46/i10/}.
}
\seealso{
\code{\link{setEvidence}}, \code{\link{getEvidence}},
\code{\link{retractEvidence}}, \code{\link{pEvidence}}
}
\author{
Søren Højsgaard, \email{sorenh@math.aau.dk}
}
\keyword{models}
\keyword{utilities}
