graphGUI <- function(graph="createdGraph", pvalues=numeric(0), grid=0, debug=FALSE, experimentalFeatures=FALSE) {
	if (!is.character(graph)) {
		if ("graphMCP" %in% class(graph)) {
			newGraphName <- "createdGraph"
			i <- 2
			while(exists(newGraphName, envir=globalenv())) {
				newGraphName <- paste("createdGraph", i, sep="")
				i <- i + 1
			}
			assign(newGraphName, updateGraphToNewClassDefinition(graph), envir=globalenv())
			graph <- newGraphName
		} else {
			warning("Please specify the variable name for the graph as character.")
			stack <- sys.calls()
			stack.fun <- Filter(function(.) .[[1]] == as.name("graphGUI"), stack)
			graph <- make.names(deparse(stack.fun[[1]][[2]]))
			warning(paste("We guess you wanted to use graphGUI(\"",graph,"\")",sep=""))
		}
	} else {
		if (exists(graph, envir=globalenv())) {
			if ("graphMCP" %in% class(get(graph, envir=globalenv()))) {
				assign(graph, updateGraphToNewClassDefinition(get(graph, envir=globalenv())), envir=globalenv())
				if (is.null(getXCoordinates(get(graph, envir=globalenv())))||is.null(getYCoordinates(get(graph, envir=globalenv())))) {
					assign(graph, placeNodes(get(graph, envir=globalenv())), envir=globalenv())
				}
			} else {
				stop(paste("The variable",graph,"already exists and is no graphMCP object."))
			}
		}
	}
	invisible(.jnew("org/af/gMCP/gui/CreateGraphGUI", make.names(graph), pvalues, debug, grid, experimentalFeatures))	
}

corMatWizard <- function(n=dim(matrix)[1], matrix=paste("diag(",n,")"), names=paste("H",1:n,sep="")) {
	if (!is.character(matrix)) {
		warning("Please specify the matrix name as character.")
		stack <- sys.calls()
		stack.fun <- Filter(function(.) .[[1]] == as.name("corMatWizard"), stack)
		matrix <- make.names(deparse(stack.fun[[1]][[2]]))
		warning(paste("We guess you wanted to call corMatWizard(matrix=\"",matrix,"\")",sep=""))
	}
	invisible(.jnew("org/af/gMCP/gui/dialogs/MatrixCreationDialog", matrix, names))
}