% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/behaviors.R
\name{optimize_viewport_transform}
\alias{optimize_viewport_transform}
\title{Configure Optimize Viewport Transform Behavior}
\usage{
optimize_viewport_transform(
  key = "optimize-viewport-transform",
  enable = TRUE,
  debounce = 200,
  shapes = JS("(type) => type === 'node'"),
  ...
)
}
\arguments{
\item{key}{Unique identifier for the behavior (string, default: "optimize-viewport-transform").}

\item{enable}{Whether to enable this behavior (boolean or JS function, default: TRUE).}

\item{debounce}{How long after the operation ends to restore the visibility of all elements
in milliseconds (number, default: 200).}

\item{shapes}{Function to specify which graphical elements should remain visible during canvas
operations (JS function, default: returns TRUE for nodes).}

\item{...}{Extra parameters. See \url{https://g6.antv.antgroup.com/en/manual/behavior/optimize-viewport-transform}.}
}
\value{
A list with the configuration settings for the optimize-viewport-transform behavior.
}
\description{
Creates a configuration object for the optimize-viewport-transform behavior in G6.
This behavior improves performance during viewport transformations by temporarily
hiding certain elements.
}
\examples{
# Basic configuration
config <- optimize_viewport_transform()

# Custom configuration
config <- optimize_viewport_transform(
  key = "my-optimize-transform",
  debounce = 500,
  shapes = JS("(type) => type === 'node' || type === 'edge'")
)

# With conditional enabling
config <- optimize_viewport_transform(
  enable = JS("(event) => event.getCurrentTransform().zoom < 0.5")
)
}
