% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/behaviors.R
\name{drag_canvas}
\alias{drag_canvas}
\title{Configure Drag Canvas Behavior}
\usage{
drag_canvas(
  key = "drag-canvas",
  enable = NULL,
  animation = NULL,
  direction = c("both", "x", "y"),
  range = NULL,
  sensitivity = 10,
  trigger = NULL,
  onFinish = NULL,
  ...
)
}
\arguments{
\item{key}{Behavior unique identifier. Useful to modify this behavior from JS side.}

\item{enable}{Whether to enable this behavior (boolean or function, default: function that enables dragging only on canvas).}

\item{animation}{Drag animation configuration for keyboard movement (list, default: NULL).}

\item{direction}{Allowed drag direction: "x", "y", or "both" (string, default: "both").}

\item{range}{Draggable viewport range in viewport size units (number or numeric vector, default: Inf).}

\item{sensitivity}{Distance to trigger a single keyboard movement (number, default: 10).}

\item{trigger}{Keyboard keys to trigger dragging (list, default: NULL).}

\item{onFinish}{Callback function when dragging is completed (function, default: NULL).}

\item{...}{Extra parameters. See \url{https://g6.antv.antgroup.com/en/manual/behavior/drag-canvas}.}
}
\value{
A list with the configuration settings for the drag-canvas behavior.
}
\description{
Creates a configuration object for the drag-canvas behavior in G6.
This allows users to drag the canvas to pan the view.
}
\examples{
# Basic configuration
config <- drag_canvas()

# Custom configuration
config <- drag_canvas(
  enable = TRUE,
  direction = "x",
  range = c(-100, 100),
  sensitivity = 5,
  trigger = list(
   up = "ArrowUp",
   down = "ArrowDown",
   left = "ArrowLeft",
   right = "ArrowRight"
  )
)
}
