% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TEF.r
\name{TEF}
\alias{TEF}
\title{Total Error of Fit of Fuzzy Regression Model}
\usage{
TEF(object, sc = 1e-06, ...)
}
\arguments{
\item{object}{a \code{fuzzylm} object.}

\item{sc}{scaling constant used for numerical stability when spreads are equal to zero.}

\item{...}{additional arguments passed to the \code{integrate} function.}
}
\value{
A numeric vector with pairwise differences between the triangular fuzzy
  numbers.
}
\description{
Calculates total error of fit of a fuzzy regression model based on the
concept of difference in membership functions of triangular fuzzy numbers
between the estimated and observed fuzzy dependent variables.
}
\details{
The \code{TFN1} and \code{TFN2} can be other objects that can be coerced to
  matrices with three columns.
}
\examples{
data(fuzzydat)
f <- fuzzylm(y ~ x, fuzzydat$lee)
TEF(f)
}
\references{
Kim B. and Bishu R. R. (1998) Evaluation of fuzzy linear regression
  models by comparing membership functions. \emph{Fuzzy Sets and Systems}
  100: 343-352.
}
\seealso{
\code{\link{fuzzylm}}
}
