# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Identify heat waves that are a certain number of days long
#'
#' This function identifies heat waves that are a certain number of days long.
#'
#' @param heatwaveLength Number of days that a heat wave lasts under the
#'    user's definition
#' @param tempsExceedingCutoff A vector of 1s and 0s the length of the
#'     number of days in the time series. 1 means the temperature for that
#'     day exceeds the calculated threshold; 0 means it does not exceed the
#'     threshold.
#'
#' @return A dataframe containing information about the heat waves for this
#'    series. It contains two columns: \code{hw} and \code{hw.number}.
#' @export
IDHeatwavesCPP <- function(heatwaveLength, tempsExceedingCutoff) {
    .Call('futureheatwaves_IDHeatwavesCPP', PACKAGE = 'futureheatwaves', heatwaveLength, tempsExceedingCutoff)
}

#' Helper function that adds entries
#'
#' This is a helper function for IDHeatwavesCPP that adds entries
#' to the data structures that track heatwave information
#'
#' @param index A running index.
#' @param hwSize Size of the heat wave to be added.
#' @param hwCounter Current number of heat waves.
#' @param hw A reference of the vector that contains the heat waves
#' @param hwNumber A reference of the vector that contains the heat wave
#'    numbers.
#'
storeHeatwaveEntry <- function(index, hwSize, hwCounter, hw, hwNumber) {
    invisible(.Call('futureheatwaves_storeHeatwaveEntry', PACKAGE = 'futureheatwaves', index, hwSize, hwCounter, hw, hwNumber))
}

#' Helper function that adds zeroes
#'
#' This function is a helper function that adds zeros to the data structures
#' that track heat wave information
#'
#' @param potentialHeatwave Size of the potential heat wave that turned out
#'    not to be a heat wave.
#' @param hw A reference of the vector that contains the heat waves
#' @param hwNumber A reference of the vector that contains the heat wave
#'    numbers.
#' @inheritParams storeHeatwaveEntry
#'
storeZeroes <- function(index, potentialHeatwave, hw, hwNumber) {
    invisible(.Call('futureheatwaves_storeZeroes', PACKAGE = 'futureheatwaves', index, potentialHeatwave, hw, hwNumber))
}

# Register entry points for exported C++ functions
methods::setLoadAction(function(ns) {
    .Call('futureheatwaves_RcppExport_registerCCallable', PACKAGE = 'futureheatwaves')
})
