% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process.R
\name{processThresholds}
\alias{processThresholds}
\title{Calculate threshold temperatures}
\usage{
processThresholds(model, global, custom)
}
\arguments{
\item{model}{List with parsed information about the directory structure for
a specific climate model from the user-specified projections directory.
This list is a subset of the list generated by
\code{acquireDirectoryStructure}.}

\item{global}{An list object created by \code{\link{gen_hw_set}} that
includes user specifications (e.g., the path to the output directory, the
path to the input climate projections, the dataframe with city
locations).}

\item{custom}{An list object created by \code{\link{gen_hw_set}} that
includes user specifications (e.g., the name of the R function to
use to identify heat waves, alternative upper and lower year boundaries
for the data used to determine threshold temperatures for the heat wave
definition, alternative upper and lower year boundaries
for the projection period of the heat wave datasets being generated).}
}
\value{
A list with two elements: (1) a vector with one element for
   each city included in the user-specified city location
   file, with each element value giving the threshold temperature for the
   heat wave definition for a city, in the same order that cities
   are listed in the user-specified \code{citycsv} file and (2) the
   components of the dataframe of climate model grid locations that will
   ultimately be output as the climate model grid locations file.
}
\description{
This function calculates the threshold temperatures required to identify
heat waves in the climate projection data using the ensemble member specified
by \code{threshold_ensemble} in \code{\link{gen_hw_set}}. This threshold is
used in later functions to identify heat waves.
}

