% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/availableCores.R
\name{availableCores}
\alias{availableCores}
\title{Get number of available cores on current machine}
\usage{
availableCores(constraints = NULL,
  methods = getOption("future.availableCoresMethods", c("system",
  "mc.cores+1", "_R_CHECK_LIMIT_CORES_", "Slurm", "PBS", "SGE")),
  na.rm = TRUE, default = c(current = 1L), which = c("min", "max", "all"))
}
\arguments{
\item{constraints}{An optional character specifying under what
constraints ("purposes") we are requesting the values.
For instance, on systems where multicore processing is not supported
(i.e. Windows), using \code{constrains="multicore"} will force a
single core to be reported.}

\item{methods}{A character vector specifying how to infer the number
of available cores.}

\item{na.rm}{If TRUE, only non-missing settings are considered/returned.}

\item{default}{The default number of cores to return if no non-missing
settings are available.}

\item{which}{A character specifying which settings to return.
If \code{"min"}, the minimum value is returned.
If \code{"max"}, the maximum value is returned (be careful!)
If \code{"all"}, all values are returned.}
}
\value{
Return a positive (>=1) integer.
If \code{which="all"}, then more than one value may be returned.
Together with \code{na.rm=FALSE} missing values may also be returned.
}
\description{
The current/main R session counts as one, meaning the minimum
number of cores available is always at least one.
}
\details{
The following settings ("methods") for inferring the number of cores
are supported:
\itemize{
 \item \code{"system"} -
   Query \code{\link[parallel]{detectCores}()}.
 \item \code{"mc.cores+1"} -
   If available, returns the value of option
   \code{\link[base:options]{mc.cores}} + 1.
   Note that \option{mc.cores} is defined as the number of
   \emph{additional} R processes that can be used in addition to the
   main R process.  This means that with \code{mc.cores=0} all
   calculations should be done in the main R process, i.e. we have
   exactly one core available for our calculations.
   The \option{mc.cores} option defaults to environment variable
   \env{MC_CORES} (and is set accordingly when the \pkg{parallel}
   package is loaded).  The \option{mc.cores} option is used by for
   instance \code{\link[parallel]{mclapply}()}.
 \item \code{"PBS"} -
   Query Torque/PBS environment variable \env{PBS_NUM_PPN}.
   Depending on PBS system configuration, this \emph{resource} parameter
   may or may not default to one.  It can be specified when submitting
   a job as in, for instance, \code{qsub -l nodes=4:ppn=2}, which
   requests four nodes each with two cores.
 \item \code{"SGE"} -
   Query Sun/Oracle Grid Engine (SGE) environment variable
   \env{NSLOTS}.
   It can be specified when submitting a job as in, for instance,
   \code{qsub -pe by_node 2}, which two cores on a single machine.
 \item \code{"Slurm"} -
   Query Simple Linux Utility for Resource Management (Slurm)
   environment variable \env{SLURM_CPUS_PER_TASK}.
   This may or may not be set.  It can be set when submitting a job,
   e.g. \code{sbatch --cpus-per-task=2 hello.sh} or by adding
   \code{#SBATCH --cpus-per-task=2} to the `hello.sh` script.
}
For any other value of a \code{methods} element, the R option with the
same name is queried.  If that is not set, the system environment
variable is queried.  If neither is set, a missing value is returned.
}
\keyword{internal}

