% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/futureAssign.R
\name{futureAssign}
\alias{\%<=\%}
\alias{\%=>\%}
\alias{futureAssign}
\title{Create a future and assign its value to a variable as a promise}
\usage{
futureAssign(name, value, envir = parent.frame(), assign.env = envir,
  substitute = TRUE)
}
\arguments{
\item{name}{the name of the variable (and the future) to assign.}

\item{value}{the expression to be evaluated in the future and
whose value will be assigned to the variable.}

\item{envir}{The environment from which global variables used by
the expression should be search for.}

\item{assign.env}{The environment to which the variable should
be assigned.}

\item{substitute}{Controls whether \code{expr} should be
\code{substitute()}:d or not.}
}
\value{
A \link{Future} invisibly.
}
\description{
Method and infix operators for creating futures and assigning
their values as variables using \link[base]{promise}s.  Trying
to access such a "future variable" will correspond to requesting
the value of the underlying future.  If the the future is already
resolved at this time, then the value will be available
instantaneously and the future variable will appear as any other
variable.  If the future is unresolved, then the current process
will block until the future is resolved and the value is available.
}
\details{
This function creates a future and a corresponding
\emph{\link[base]{promise}}, which hold the future's value.
Both the future and the promise are assigned to environment
\code{assign.env}.  The name of the promise is given by \code{name}
and the name of the future is \code{.future_<name>}.
The future is also returned invisibly.
}
\examples{
## Future assignment via "assign" function
futureAssign("A", {
  x <- 3
  x^2
})
cat("Value 'A': ", A, sep="")


## Equivalent via infix "assign" operator
A \%<=\% {
  x <- 3
  x^2
}
cat("Value 'A': ", A, sep="")


## A global variable
a <- 1

## Three future evaluations
A \%<=\% { 0.1 }
B \%<=\% { 0.2 }
C \%<=\% { z <- a+0.3 }

## Sleep until 'C' is available
cat("Value 'C': ", C, sep="")

## Sleep until 'A' is available
cat("Value 'A': ", A, sep="")

## Sleep until 'C' is available
cat("Value 'B': ", B, sep="")
}
\seealso{
The \code{\link{futureOf}()} function can be used to get the
Future object of a future variable.
}

