% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distinctiveness.R
\name{distinctiveness_stack}
\alias{distinctiveness_stack}
\title{Functional Distinctiveness on a stacked data.frame}
\usage{
distinctiveness_stack(com_df, sp_col, com, abund = NULL, dist_matrix)
}
\arguments{
\item{com_df}{a stacked (= tidy) data.frame from a single community with each
row representing a species in a community}

\item{sp_col}{a character vector, the name of the species column in \code{com_df}}

\item{com}{a character vector, the column name for communities names}

\item{abund}{a character vector, the name of the column containing relative
abundances values}

\item{dist_matrix}{a functional distance matrix as given by
\code{compute_dist_matrix()}, with species name as row and column names}
}
\value{
the same data.frame with the additional \strong{Di} column giving
functional distinctiveness values for each species
}
\description{
Compute Functional Distinctiveness for several communities, from a stacked
(or tidy) data.frame of communities, with one column for species identity,
one for community identity and an optional one for relative abundances. Also
needs a species functional distances matrix. Functional distinctiveness
relates to the functional "originality" of a species in a community. The
closer to 1 the more the species is functionally distinct from the rest of
the community. See \code{\link[=distinctiveness]{distinctiveness()}} function or the
functional rarity indices vignette included in the package
(type \code{vignette("rarity_indices", package = "funrar")}), for more details
on the metric. \strong{IMPORTANT NOTE}: in order to get functional rarity indices
between 0 and 1, the distance metric has to be scaled between 0 and 1.
}
\examples{
data("aravo", package = "ade4")

# Example of trait table
tra = aravo$traits[, c("Height", "SLA", "N_mass")]
# Distance matrix
dist_mat = compute_dist_matrix(tra)

# Site-species matrix converted into data.frame
mat = as.matrix(aravo$spe)
mat = make_relative(mat)
dat = matrix_to_stack(mat, "value", "site", "species")
dat$site = as.character(dat$site)
dat$species = as.character(dat$species)

di_df = distinctiveness_stack(dat, "species", "site", "value", dist_mat)
head(di_df)

}
\seealso{
\code{\link[=scarcity_stack]{scarcity_stack()}},
\code{\link[=uniqueness_stack]{uniqueness_stack()}},
\code{\link[=restrictedness_stack]{restrictedness_stack()}};
\code{\link[=distinctiveness]{distinctiveness()}} Details section for detail on the index
}
