% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/partition.R
\name{partition}
\alias{partition}
\title{Partition a vector in two}
\usage{
partition(x, predicate)
}
\arguments{
\item{x}{vector or list to partition.}

\item{predicate}{a function returning a boolean value, to apply to each
element of x.}
}
\value{
A list of two elements. The first element contains elements of x
  satisfying the predicate, the second the rest of x. Missing values will be
  discarded.
}
\description{
Split a vector or a list in 2 groups, given a predicate function.
}
\examples{
partition(c(2, 1, 3, 4, 1, 5), function(x) x < 3)
partition(list(1:3, NA, c(1, NA, 3)), anyNA)
}
