% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smoothKB.R
\name{smoothKB}
\alias{smoothKB}
\title{Smooth a Non PD Correlation Matrix using the Knol-Berger algorithm}
\usage{
smoothKB(R, eps = 1e+08 * .Machine$double.eps)
}
\arguments{
\item{R}{A non-positive definite correlation matrix.}

\item{eps}{Small positive number to control the size of the non-scaled
smallest eigenvalue of the smoothed R matrix. Default = 1E8 *
.Machine$double.eps}
}
\value{
\item{RKB}{A Smoothed (positive definite) correlation matrix.}
\item{eps}{Small positive number to control the size of the non-scaled
smallest eigenvalue of the smoothed R matrix.}
}
\description{
A function for smoothing a non-positive definite correlation matrix by the
method of Knol and Berger (1991).
}
\examples{

data(BadRLG)

## RKB = smoothed R
RKB<-smoothKB(R=BadRLG, eps = 1E8 * .Machine$double.eps)$RKB
print(eigen(RKB)$values)


}
\references{
Knol, D. L., & Berger, M. P. F., (1991). Empirical comparison
between factor analysis and multidimensional item response
models.\emph{Multivariate Behavioral Research, 26}, 457-477.
}
\author{
Niels Waller
}
\keyword{Statistics}
