
<!-- README.md is generated from README.Rmd. Please edit that file -->

# fundiversity

<!-- badges: start -->

[![Lifecycle:
maturing](https://img.shields.io/badge/lifecycle-maturing-blue.svg)](https://lifecycle.r-lib.org/articles/stages.html#maturing)
[![R build
status](https://github.com/Bisaloo/fundiversity/workflows/R-CMD-check/badge.svg)](https://github.com/Bisaloo/fundiversity/actions)
[![Coverage
Status](https://codecov.io/gh/Bisaloo/fundiversity/branch/master/graph/badge.svg?token=HR4YH118VT)](https://codecov.io/gh/Bisaloo/fundiversity)
<!-- badges: end -->

`fundiversity` provides a lightweight package to compute common
functional diversity indices. To a get a glimpse of what `fundiversity`
can do refer to the [introductory
vignette](https://bisaloo.github.io/fundiversity/articles/fundiversity.html).
The package is built using clear, public [design
principles](https://bisaloo.github.io/fundiversity/articles/design-principles.html)
inspired from our own experience and user feedback.

## Installation

You can install the development version from
[GitHub](https://github.com/Bisaloo/fundiversity) with:

``` r
# install.packages("devtools")
devtools::install_github("Bisaloo/fundiversity")
```

## Example

`fundiversity` lets you compute four classical functional diversity
indices: Functional Richness with `fd_fric()`, Functional Divergence
with `fd_fdiv()`, Rao’s Quadratic Entropy with `fd_raoq()`, and
Functional Evenness with `fd_feve()`. You can have a brief overview of
the indices in the [introductory
vignette](https://bisaloo.github.io/fundiversity/articles/fundiversity.html).

All indices can be computed either using global trait data or at the
site-level:

``` r
library(fundiversity)

# Get trait data included in the package
data("traits_birds")

# Compute Functional Richness of all birds included
fd_fric(traits_birds)
#>   site     FRic
#> 1   s1 230967.7

# Compute Functional Divergence
fd_fdiv(traits_birds)
#>   site      FDiv
#> 1   s1 0.7282172

# Compute Rao's Quadratic Entropy
fd_raoq(traits_birds)
#>   site        Q
#> 1   s1 170.0519

# Compute Functional Evenness
fd_feve(traits_birds)
#>   site      FEve
#> 1   s1 0.3743341
```

To compute Rao’s Quadratic Entropy, the user can also provide a distance
matrix between species directly:

``` r
dist_traits_birds = as.matrix(dist(traits_birds))

fd_raoq(traits = NULL, dist_matrix = dist_traits_birds)
#>   site        Q
#> 1   s1 170.0519
```

## Available functional diversity indices

According to Pavoine & Bonsall (2011) classification, functional
diversity indices can be classified in three “domains” that asses
different properties of the functional space: richness, divergence, and
regularity. `fundiversity` provides function to compute indices that
assess this three facets at the site scale:

| Scale                              | Richness                                                                               | Divergence                                                                                                                                                                             | Evenness                                                                               |
| ---------------------------------- | -------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------- |
| α-diversity<br />(= among sites)   | FRic with [`fd_fric()`](https://bisaloo.github.io/fundiversity/reference/fd_fric.html) | FDiv with [`fd_fdiv()`](https://bisaloo.github.io/fundiversity/reference/fd_fdiv.html)<br />Rao’s QE with [`fd_raoq()`](https://bisaloo.github.io/fundiversity/reference/fd_raoq.html) | FEve with [`fd_feve()`](https://bisaloo.github.io/fundiversity/reference/fd_feve.html) |
| β-diversity<br />(= between sites) | available in `betapart`                                                                | available in `entropart`, `betapart` or `hillR`                                                                                                                                        | available in `BAT`                                                                     |

## Related Packages

Several other packages exist that compute functional diversity indices.
We have performed a [performance
comparison](https://bisaloo.github.io/fundiversity/articles/performance.html)
between packages. We here mention some of them (but do not mention the
wrappers around these packages):

| Package Name                                           | Indices included                                            | Has vignettes | Has tests | On GitHub | On CRAN (last updated)                                     |
| ------------------------------------------------------ | ----------------------------------------------------------- | ------------- | --------- | --------- | ---------------------------------------------------------- |
| [`FD`](https://github.com/cran/FD)                     | FRic, FDiv, FDis, FEve, Rao’s QE, Functional Group Richness | :x:           | :x:       | :x:       | ![](https://www.r-pkg.org/badges/last-release/FD)          |
| [`adiv`](https://github.com/cran/adiv)                 | Functional Entropy, Functional Redundancy                   | ✅             | :x:       | :x:       | ![](https://www.r-pkg.org/badges/last-release/adiv)        |
| [`betapart`](https://github.com/cran/betapart)         | Functional β-diversity                                      | :x:           | :x:       | :x:       | ![](https://www.r-pkg.org/badges/last-release/betapart)    |
| [`entropart`](https://github.com/EricMarcon/entropart) | Functional Entropy                                          | ✅             | ✅         | ✅         | ![](https://www.r-pkg.org/badges/last-release/entropart)   |
| [`hillR`](https://github.com/daijiang/hillR)           | Functional Diversity Hill Number                            | :x:           | ✅         | ✅         | ![](https://www.r-pkg.org/badges/last-release/hillR)       |
| [`vegan`](https://github.com/vegandevs/vegan)          | Only dendrogram-based FD (`treedive()`)                     | ✅             | ✅         | ✅         | ![](https://www.r-pkg.org/badges/last-release/vegan)       |
| [`TPD`](https://github.com/cran/TPD)                   | FRic, FDiv, FEve but for probability distributions          | ✅             | :x:       | :x:       | ![](https://www.r-pkg.org/badges/last-release/TPD)         |
| [`hypervolume`](https://github.com/cran/hypervolume)   | Hypervolume measure functional diversity (\~FRic)           | :x:           | :x:       | ✅         | ![](https://www.r-pkg.org/badges/last-release/hypervolume) |
| [`BAT`](https://github.com/cardosopmb/BAT)             | β-, Richness, divergence, and evenness with hypervolumes    | :x:           | :x:       | ✅         | ![](https://www.r-pkg.org/badges/last-release/BAT)         |
