% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calibrating.R
\name{calibrate_gmean_byelt}
\alias{calibrate_gmean_byelt}
\title{Modelling the performances
 by components occurring within an assembly motif}
\usage{
calibrate_gmean_byelt(fobs, assMotif, mOccur)
}
\arguments{
\item{fobs}{a numeric vector. The vector \code{fobs} contains the
quantitative performances of assemblages.}

\item{assMotif}{a vector of labels of \code{length(fobs)}.
The vector \code{assMotif} contains the assembly motifs of assemblages.}

\item{mOccur}{a matrix of occurrence (occurrence of components).
Its first dimension equals to \code{length(fobs)}. Its second dimension
 equals to the number of components.}
}
\value{
Return a vector of \code{length(fobs)}.
Its values are computed as the average
of mean performances of assemblages
that share the same assembly motif
and that contain the same components
as the assemblage to calibrate \code{opt.model = "byelt"} .
}
\description{
The numeric vector \code{fobs} get together the properties
of assemblages belonging to different assembly motifs. The properties
\code{fobs} of assemblages belonging to a given assembly motif and
containing a given component are separately averaged. The property of
 each assemblage is computed as the average of mean values of assemblages
  containing the same components as the considered assemblage. The
  motif of each vector component is specified in the vector
  \code{assMotif}.
   The componental composition of each assemblage is specified in the
    binary matrix \code{mOccur}: \code{0} if the component does not occur,
     \code{1} if the component occurs.
}
\details{
Modelled performances are computed
using geometric mean (\code{opt.mean = "gmean"}) of performances.
Modelled performances are the average
of mean performances of assemblages
that share a same assembly motif and
that contain the same components
as the assemblage to calibrate (\code{opt.model = "byelt"}).
This procedure corresponds to a linear model with each assembly motif
based on the component occurrence in each assemblage.
If no assemblage contains component belonging to assemblage to calibrate,
performance is the mean performance of all assemblages.
}
\seealso{
\code{\link{calibrate_amean_bymot}} arithmetic mean
  by assembly motif. \cr
\code{\link{calibrate_amean_byelt}} arithmetic mean
  by elements occurring within assembly motif. \cr
\code{\link{calibrate_gmean_bymot}} geometric mean
  by assembly motif. \cr
\code{\link{calibrate_gmean_byelt}} geometric mean
  by elements occurring within assembly motif. \cr
}
\keyword{internal}
