% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/funDataMethods.R
\docType{methods}
\name{plot.irregFunData}
\alias{plot,irregFunData,missing-method}
\alias{plot.irregFunData}
\title{Plotting irregular functional data}
\usage{
plot.irregFunData(x, y, obs = 1:nObs(x), type = "b", pch = 20,
  col = grDevices::rainbow(nObs(x)), xlab = "argvals", ylab = "",
  xlim = range(x@argvals[obs]), ylim = range(x@X[obs]), add = FALSE, ...)

\S4method{plot}{irregFunData,missing}(x, y, ...)
}
\arguments{
\item{x}{An object of class \code{irregFunData}.}

\item{y}{Missing.}

\item{obs}{A vector of numerics giving the observations to plot. Defaults to
all observations in \code{x}.}

\item{type}{The type of plot. Defaults to \code{"b"} (line and point plot).
See \code{\link[graphics]{plot}} for details.}

\item{pch}{The point type. Defaults to \code{20} (solid small circles). See
\code{\link[graphics]{par}} for details.}

\item{col}{The color of the functions. Defaults to the
\code{\link[grDevices]{rainbow}} palette.}

\item{xlab,ylab}{The titles for x- and y-axis. Defaults to \code{"argvals"}
for the x-axis and no title for the y-axis. See
\code{\link[graphics]{plot}} for details.}

\item{xlim,ylim}{The limits for x- and y-axis. Defaults to the total range of
the data that is to plot. See \code{\link[graphics]{plot}} for details.}

\item{add}{Logical. If \code{TRUE}, add to current plot (only for
one-dimensional functions). Defaults to \code{FALSE}.}

\item{...}{Additional arguments to \code{\link[graphics]{plot}}.}
}
\description{
This function plots observations of irregular functional data on their
domain.
}
\examples{
oldpar <- par(no.readonly = TRUE)

# Generate data
argvals <- seq(0,2*pi,0.01)
ind <- replicate(5, sort(sample(1:length(argvals), sample(5:10,1))))
object <- irregFunData(argvals = lapply(ind, function(i){argvals[i]}),
                  X = lapply(ind, function(i){sample(1:10,1) / 10 * argvals[i]^2}))

plot(object, main = "Irregular functional data")

par(oldpar)
}
\seealso{
\code{\link{plot.funData}}, \code{\linkS4class{irregFunData}},
  \code{\link[graphics]{plot}}
}

