% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cache_clean.R
\name{cache_file_info}
\alias{cache_file_info}
\title{Get information on possibly bad files in your cache}
\usage{
cache_file_info()
}
\value{
list, with three elements:
\itemize{
\item xml_not_valid: xml files that could not be read in with
\code{xml2::read_xml()}
\item xml_abstract_only: xml files that only have abstracts.
you can of choose to retain these if you like
\item pdf_not_valid: pdf files that could not be read in with
\code{pdftools::pdf_info()}
}
}
\description{
Get information on possibly bad files in your cache
}
\details{
This function only identifies possibly bad files.
You have to remove/delete them yourself. See example for
how to do so. You can also open up your cache folder and
delete them that way as well.
}
\examples{
# identify likely bad files
res <- cache_file_info()

# you can remove them yourself, e.g.,
# invisible(lapply(res$xml_abstract_only, unlink))
}
\seealso{
Other caching-functions: 
\code{\link{cache}},
\code{\link{ftxt_cache}}
}
\concept{caching-functions}
