% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nfssem.R
\name{multiNFSSEMiPALM2}
\alias{multiNFSSEMiPALM2}
\title{multiNFSSEMiPALM2}
\usage{
multiNFSSEMiPALM2(
  Xs,
  Ys,
  Bs,
  Fs,
  Sk,
  sigma2,
  lambda,
  rho,
  Wl,
  Wf,
  p,
  maxit = 100,
  inert = inert_opt("linear"),
  threshold = 1e-06,
  verbose = TRUE,
  sparse = TRUE,
  trans = FALSE,
  B2norm = NULL,
  strict = FALSE
)
}
\arguments{
\item{Xs}{eQTL matrices}

\item{Ys}{Gene expression matrices}

\item{Bs}{initialized GRN-matrices}

\item{Fs}{initialized eQTL effect matrices}

\item{Sk}{eQTL index of genes}

\item{sigma2}{initialized noise variance from ridge regression}

\item{lambda}{Hyperparameter of lasso term in NFSSEM}

\item{rho}{Hyperparameter of fused-lasso term in NFSSEM}

\item{Wl}{weight matrices for adaptive lasso terms}

\item{Wf}{weight matrix for columnwise l2 norm adaptive group lasso}

\item{p}{number of genes}

\item{maxit}{maximum iteration number. Default 100}

\item{inert}{inertial function for iPALM. Default as k-1/k+2}

\item{threshold}{convergence threshold. Default 1e-6}

\item{verbose}{Default TRUE}

\item{sparse}{Sparse Matrix or not}

\item{trans}{Fs matrix is transposed to k x p or not. If Fs from ridge regression, trans = TRUE, else, trans = FALSE}

\item{B2norm}{B2norm matrices generated from ridge regression. Default NULL.}

\item{strict}{Converge strictly or not. Default False}
}
\value{
fit List of NFSSEM model
\describe{
\item{Bs}{ coefficient matrices of gene regulatory networks}
\item{Fs}{ coefficient matrices of eQTL-gene effect}
\item{mu}{ Bias vector}
\item{sigma2}{ estimate of covariance in SEM}
}
}
\description{
Implementing NFSSEM algorithm for network inference. If Xs is identify for different conditions, multiNFSSEMiPALM will be use, otherwise, please
use \code{multiNFSSEMiPALM2} for general cases
}
