% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eddy.R
\name{eddy}
\alias{eddy}
\title{Eddy Current Correction}
\usage{
eddy(infile, mask, acq_file, index_file, bvecs, bvals, outfile = NULL,
  retimg = TRUE, opts = "", verbose = TRUE, ...)
}
\arguments{
\item{infile}{input filename of 4D image.}

\item{mask}{Mask filename (or class nifti)}

\item{acq_file}{A text-file describing the acquisition parameters for the 
different images in \code{infile} The format of this file is identical 
to that used by topup (though the parameter is called \code{--datain} 
there).}

\item{index_file}{A text-file that determines the relationship between 
on the one hand the images in \code{infile} and on the other hand the 
acquisition parameters in \code{acq_file}.}

\item{bvecs}{A text file with normalised vectors describing 
the direction of the diffusion weighting.}

\item{bvals}{A text file with b-values describing the "amount of" 
diffusion weighting}

\item{outfile}{Output file basename}

\item{retimg}{(logical) return image of class nifti}

\item{opts}{Additional options to pass to arguments 
passed to \code{\link{eddy}}}

\item{verbose}{print diagnostic messages}

\item{...}{Not currently used}
}
\value{
Result from system command currently
}
\description{
This function calls \code{eddy} from FSL for 
DTI Processing
}
