% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brainview_magick.R
\name{arrange.brainview.images}
\alias{arrange.brainview.images}
\title{Combine several brainview images into a new figure.}
\usage{
arrange.brainview.images(
  brainview_images,
  output_img,
  colorbar_img = NULL,
  silent = FALSE,
  grid_like = TRUE,
  border_geometry = "5x5",
  background_color = "white"
)
}
\arguments{
\item{brainview_images}{vector of character strings, paths to the brainview images, usually in PNG format}

\item{output_img}{path to output image that including the file extension}

\item{colorbar_img}{path to the main image containing the separate colorbar, usually an image in PNG format}

\item{silent}{logical, whether to suppress messages}

\item{grid_like}{logical, whether to arrange the images in a grid-like fashion. If FALSE, they will all be merged horizontally.}

\item{border_geometry}{string, a geometry string passed to \code{magick::image_border} to define the borders to add to each image tile. The default value adds 5 pixels, both horizontally and vertically.}

\item{background_color}{string, a valid ImageMagick color string such as "white" or "#000080". The color to use when extending images (e.g., when creating the border).}
}
\value{
vector of character strings, paths to the brainview images. This is the input parameter 'brainview_images'.
}
\description{
Combine several brainview images into a new figure.
}
