% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vis_volume.R
\name{magick.grid}
\alias{magick.grid}
\title{Arrange a multi-frame ImageMagick image into a grid.}
\usage{
magick.grid(
  magickimage,
  per_row = 5L,
  per_col = NULL,
  background_color = "#000000"
)
}
\arguments{
\item{magickimage}{an ImageMagick image}

\item{per_row}{positive integer, the number of subimages per row in the output image. If `NULL`, automatically computed from the number of slices and the `per_col` parameter.}

\item{per_col}{positive integer, the number of subimages per column in the output image. If `NULL`, automatically computed from the number of slices and the `per_row` parameter.}

\item{background_color}{string, a valid ImageMagick color string such as "white" or "#000080". The color to use when extending images (e.g., when creating the border). Defaults to black.}
}
\description{
Arrange all subimages of the given ImageMagick image into a single 2D image, that contains the subimages arranged in a grid-like structure. Consecutive subimages will be appear the same row.
}
\keyword{internal}
