% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/morph_atlas_agg.R
\name{get.atlas.region.names}
\alias{get.atlas.region.names}
\title{Determine atlas region names from a subject.}
\usage{
get.atlas.region.names(atlas, template_subjects_dir = NULL,
  template_subject = "fsaverage", hemi = "lh")
}
\arguments{
\item{atlas, }{string. The atlas name. E.g., "aparc", "aparc.2009s", or "aparc.DKTatlas". Used to construct the name of the annotation file to be loaded.}

\item{template_subjects_dir, }{string. The directory containing the dir of the template_subject. E.g., the path to FREESURFER_HOME/subjects. If NULL, env vars will be searched for candidates, and the function will fail if they are not set correctly. Defaults to NULL.}

\item{template_subject, }{string. The subject identifier. Defaults to 'fsaverage'.}

\item{hemi, }{string, one of 'lh' or 'rh'. The hemisphere name. Used to construct the names of the annotation and morphometry data files to be loaded. Defaults to 'lh'. Should not matter much, unless you do not have the file for one of the hemis for some reason.}
}
\value{
vector of strings, the region names.
}
\description{
Determine atlas region names from a subject. WARNING: Not all subjects have all regions of an atlas. You should use an average subject like fsaverage to get all regions.
}
\examples{
\donttest{
   fsbrain::download_optional_data();
   subjects_dir = fsbrain::get_optional_data_filepath("subjects_dir");
   atlas_regions = get.atlas.region.names('aparc',
    template_subjects_dir=subjects_dir, template_subject='subject1');
}

}
\seealso{
Other atlas functions: \code{\link{group.agg.atlas.native}},
  \code{\link{group.agg.atlas.standard}},
  \code{\link{group.annot}},
  \code{\link{regions.to.ignore}},
  \code{\link{spread.values.over.annot}},
  \code{\link{spread.values.over.hemi}},
  \code{\link{spread.values.over.subject}},
  \code{\link{subject.annot}},
  \code{\link{subject.atlas.agg}}
}
\concept{atlas functions}
