% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fsdir_abstraction_subject.R
\name{apply.label.to.morphdata}
\alias{apply.label.to.morphdata}
\title{Load a label from file and apply it to morphometry data.}
\usage{
apply.label.to.morphdata(morphdata, subjects_dir, subject_id, hemi, label,
  masked_data_value = NA)
}
\arguments{
\item{morphdata}{numerical vector, the morphometry data for one hemisphere}

\item{subjects_dir}{string. The FreeSurfer SUBJECTS_DIR, i.e., a directory containing the data for all your subjects, each in a subdir named after the subject identifier.}

\item{subject_id}{string. The subject identifier}

\item{hemi}{string, one of 'lh', 'rh' or 'both'. The hemisphere name. Used to construct the names of the annotation and morphometry data files to be loaded.}

\item{label}{string. Name of the label file, without the hemi part (if any), optionally including the '.label' suffix. E.g., 'cortex.label' or 'cortex' for '?h.cortex.label'.}

\item{masked_data_value}{numerical, the value to set for all morphometry data values of vertices which are *not* part of the label. Defaults to NA.}
}
\value{
numerical vector, the masked data.
}
\description{
This function will set all values in morphdata which are *not* part of the label loaded from the file to NA (or whatever is specified by 'masked_data_value'). This is typically used to ignore values which are not part of the cortex (or any other label) during your analysis.
}
\seealso{
Other label functions: \code{\link{apply.labeldata.to.morphdata}},
  \code{\link{vis.labeldata.on.subject}},
  \code{\link{vis.subject.label}}

Other morphometry data functions: \code{\link{apply.labeldata.to.morphdata}},
  \code{\link{group.morph.native}},
  \code{\link{group.morph.standard}},
  \code{\link{subject.morph.native}},
  \code{\link{subject.morph.standard}}
}
\concept{label functions}
\concept{morphometry data functions}
