% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{cutoff}
\alias{cutoff}
\title{Choosing most important features}
\usage{
cutoff(feature.set, threshold)
}
\arguments{
\item{feature.set}{a matrix that contains feature weights.}

\item{threshold}{the required sparsity of the resulting feature set}
}
\value{
returns a binary feature matrix.
Columns correspond to components of the time series; rows correspond to lags.
}
\description{
\code{cutoff} chooses features of highest importance to reach the required percent of sparsity
}
\examples{

# Load traffic data
data(traffic.mini)

# Scaling is sometimes useful for feature selection
# Exclude the first column - it contains timestamps
data <- scale(traffic.mini$data[,-1])

mCCF<-fsMTS(data, max.lag=3, method="CCF")
cutoff(mCCF, 0.3)
cutoff(mCCF, 0.1)

mIndependent<-fsMTS(data, max.lag=3, method="ownlags")
cutoff(mIndependent, 0.3)
cutoff(mIndependent, 0.1)
}
