% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list.R
\name{dir_ls}
\alias{dir_ls}
\alias{dir_map}
\alias{dir_walk}
\alias{dir_info}
\title{List files}
\usage{
dir_ls(path = ".", all = FALSE, recursive = FALSE, type = "any",
  glob = NULL, regexp = NULL, invert = FALSE, ...)

dir_map(path = ".", fun, all = FALSE, recursive = FALSE, type = "any")

dir_walk(path = ".", fun, all = FALSE, recursive = FALSE, type = "any")

dir_info(path = ".", all = FALSE, recursive = FALSE, type = "any",
  regexp = NULL, glob = NULL, ...)
}
\arguments{
\item{path}{A character vector of one or more paths.}

\item{all}{If \code{TRUE} hidden files are also returned.}

\item{recursive}{Should directories be listed recursively?
the filenames.}

\item{type}{File type(s) to return, one or more of "any", "file", "directory",
"symlink", "FIFO", "socket", "character_device" or "block_device".}

\item{glob}{Either a glob (e.g. \code{*.csv}) or a regular
expression (e.g. \code{[.]csv$}) passed on to \code{\link[=grep]{grep()}} to filter paths.}

\item{regexp}{Either a glob (e.g. \code{*.csv}) or a regular
expression (e.g. \code{[.]csv$}) passed on to \code{\link[=grep]{grep()}} to filter paths.}

\item{invert}{If \code{TRUE} return files which do \emph{not} match}

\item{...}{Additional arguments passed to \link{grep}.}

\item{fun}{A function, taking one parameter, the current path entry.}
}
\description{
\code{dir_ls()} is equivalent to the \code{ls} command. It returns filenames as a
\code{fs_path} character vector.

\code{dir_info()} is equivalent to \code{ls -l} and a shortcut for
\code{file_info(dir_ls())}.

\code{dir_map()} applies a function \code{fun()} to each entry in the path and returns
the result in a list.

\code{dir_walk()} calls \code{fun} for its side-effect and returns the input \code{path}.
}
\examples{
dir_ls(R.home("share"), type = "directory")

link_create(system.file(package = "base"), "base")

dir_ls("base", recursive = TRUE, glob = "*.R")
dir_map("base", identity)
dir_walk("base", str)
dir_info("base")

# Cleanup
link_delete("base")
}
