% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/temp.R
\name{file_temp}
\alias{file_temp}
\alias{file_temp_push}
\alias{file_temp_pop}
\title{Create names for temporary files}
\usage{
file_temp(pattern = "file", tmp_dir = tempdir(), ext = "")

file_temp_push(path)

file_temp_pop()
}
\arguments{
\item{pattern}{A character vector with the non-random portion of the name.}

\item{tmp_dir}{The directory the file will be created in.}

\item{ext}{The file extension of the temporary file.}

\item{path}{A character vector of one or more paths.}
}
\description{
\code{file_temp()} returns the name which can be used as a temporary file.
}
\details{
\code{file_temp_push()} can be used to supply deterministic entries in the
temporary file stack. This can be useful for reproducibility in like example
documentation and vignettes.

\code{file_temp_pop()} can be used to explicitly remove an entry from the
internal stack, however generally this is done instead by calling
\code{file_temp()}.
}
\examples{
\dontshow{file_temp_push("/tmp/filedd461c46df20")}
# default just passes the arguments to `tempfile()`
file_temp()

# But you can also make the results deterministic
file_temp_push(letters)
file_temp()
file_temp()

# Or explicitly remove values
while (!is.null(file_temp_pop())) next
file_temp_pop()
}
