% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/csv.R
\name{csv}
\alias{csv}
\alias{read_csv}
\alias{write_csv}
\title{Read and Write a Comma Separated File}
\usage{
read_csv(file, ...)

write_csv(x, file = NULL, csv_type = c(NA, "standard", "german"))
}
\arguments{
\item{file}{The path to the file to be read or written.}

\item{...}{Arguments passed to \code{\link[utils:read.csv]{utils::read.csv}}
or \code{\link[utils:read.csv2]{utils::read.csv2}}.}

\item{x}{The object to write to disk.}

\item{csv_type}{Which \command{csv} type is to be used. If \code{NA}, the
\code{csv} attribute is read from the object.}
}
\value{
For \bold{\code{read_csv}}: An object read from the file.

For \bold{\code{write_csv}}: The object with updated \code{hash}
(and possibly \code{path} and \code{csv})
attribute.
}
\description{
Functions to read and write CSV files. The objects returned by these
functions are \code{\link{data.frame}s} with the following attributes:
\describe{
  \item{path}{The path to the file on disk.}
  \item{csv}{The type of CSV: either \code{standard} or \code{german}.}
  \item{hash}{The hash value computed with \pkg{digest}'s digest function, if
  \pkg{digest} is installed.}
}

\code{read_csv} is a wrapper to determine whether to use
\code{\link[utils:read.csv2]{utils:read.csv2}} or
\code{\link[utils:read.csv2]{utils:read.csv2}}.
It sets the above three arguments.

\code{write_csv} compares the \code{hash} value stored in the object's
attribute
with the objects current hash value. If they differ, it writes the object to
the \code{file} argument or, if not given, to the \code{path}
stored in the object's attribute. If no \code{csv_type} is given, it uses
the \code{csv} type stored in object's attribute.
If \pkg{digest} is not installed, the object will (unconditionally) be
written to disk.
}
\examples{
# read from standard CSV
f <- tempfile()
write.csv(mtcars, file = f)
str(read_csv(f))
f <- tempfile()
write.csv2(mtcars, file = f)
str(read_csv(f))
# write to standard CSV
f <- tempfile()
d <- mtcars
str(d <- write_csv(d, file = f))
file.mtime(f)
Sys.sleep(2) # make sure the mtime would have changed
write_csv(d, file = f)
file.mtime(f)
}
\seealso{
Other CSV functions: 
\code{\link{bulk_read_csv}()},
\code{\link{bulk_write_csv}()},
\code{\link{csv2csv}()}
}
\concept{CSV functions}
