% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/use_vars_template.R
\name{use_vars_template}
\alias{use_vars_template}
\title{Use a template to define SCSS variables}
\usage{
use_vars_template(
  output_file,
  theme = c("default", "cerulean", "cosmo", "cyborg", "darkly", "flatly", "journal",
    "lumen", "paper", "readable", "sandstone", "simplex", "slate", "spacelab",
    "superhero", "united", "yeti"),
  open = interactive()
)
}
\arguments{
\item{output_file}{Path where to create the template, use \code{".scss"} as file extension.}

\item{theme}{Base theme to use, e.g. \code{"cosmo"} to start modifying the cosmo theme.}

\item{open}{Open the newly created file for editing? Happens in RStudio,
if applicable, or via \code{utils::file.edit()} otherwise.}
}
\description{
Open a SCSS template to modify variables,
after use \link{bs_vars_file} to import those variables and create a theme.
}
\note{
After use \code{\link{bs_vars_file}} to use the template.
}
\examples{
# For example, we use a temporary file
custom <- tempfile(fileext = ".scss")

# this will open a template
# to modify variables of the flatly theme
use_vars_template(
  output_file = custom,
  theme = "flatly"
)

# after use bs_vars_file() to use the template

# clean up
unlink(custom)
}
