% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_pretty.R
\name{create_pretty}
\alias{create_pretty}
\title{Create a custom CSS file for pretty-checkbox}
\usage{
create_pretty(output_file, default = NULL, primary = NULL,
  success = NULL, info = NULL, warning = NULL, danger = NULL)
}
\arguments{
\item{output_file}{Specifies path to output file for compiled CSS.}

\item{default}{Default color.}

\item{primary}{Primary color.}

\item{success}{Success color.}

\item{info}{Info color.}

\item{warning}{Warning color.}

\item{danger}{Danger color.}
}
\value{
If \code{output_file = NULL}, the function returns a string value of the compiled CSS.
 If the output path is specified, the compiled CSS is written to that file and \code{invisible()} is returned.
}
\description{
This allow you to change colors of \code{\link[shinyWidgets]{prettyCheckbox}},
 \code{\link[shinyWidgets]{prettyRadioButtons}}
}
\examples{

# Temporary file
tmp <- file.path(tempdir(), "my-pretty.css")

# Create the new theme
create_pretty(
  output_file = tmp,
  primary = "#FFFF00"
)

# Clean
unlink(tmp)
}
