% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vars-bootstrap.R
\name{bs_vars_progress}
\alias{bs_vars_progress}
\title{Bootstrap CSS progress variables}
\usage{
bs_vars_progress(bg = NULL, bar_color = NULL, border_radius = NULL,
  bar_bg = NULL, bar_success_bg = NULL, bar_warning_bg = NULL,
  bar_danger_bg = NULL, bar_info_bg = NULL)
}
\arguments{
\item{bg}{Background color of the whole progress component}

\item{bar_color}{Progress bar text color}

\item{border_radius}{Variable for setting rounded corners on progress bar.}

\item{bar_bg}{Default progress bar color.}

\item{bar_success_bg}{Success progress bar color.}

\item{bar_warning_bg}{Warning progress bar color.}

\item{bar_danger_bg}{Danger progress bar color.}

\item{bar_info_bg}{Info progress bar color.}
}
\value{
a \code{list} that can be used in \code{\link{create_theme}}.
}
\description{
Those variables can be used to customize
 progress bars (e.g. \code{\link[shinyWidgets:progress-bar]{shinyWidgets::progressBar}}
 and \code{\link[shiny:Progress]{shiny::Progress or shiny::withProgress}})
 in Bootstrap and Bootswatch themes.
}
\examples{
bs_vars_progress(
  border_radius = "15px",
  bar_bg = "#1B9E77",
  bar_info_bg = "#D95F02",
  bar_success_bg = "#7570B3",
  bar_danger_bg = "#E7298A"
)

if (interactive()) {
  library(shiny)
  library(shinyWidgets)

  ui <- fluidPage(
    use_theme(
      create_theme(
        theme = "default",
        bs_vars_progress(
          border_radius = "15px",
          bar_bg = "#1B9E77",
          bar_info_bg = "#D95F02",
          bar_success_bg = "#7570B3",
          bar_danger_bg = "#E7298A"
        ),
        output_file = NULL
      )
    ),
    tags$h1("Custom progress bars"),
    fluidRow(
      column(
        width = 6,
        progressBar(
          "pb1", value = 90, display_pct = TRUE
        )
      ),
      column(
        width = 6,
        progressBar(
          "pb2", value = 70, status = "info", display_pct = TRUE
        )
      ),
      column(
        width = 6,
        progressBar(
          "pb3", value = 50, status = "success", display_pct = TRUE
        )
      ),
      column(
        width = 6,
        progressBar(
          "pb4", value = 30, status = "danger", display_pct = TRUE
        )
      )
    ),
    plotOutput("plot")
  )

  server <- function(input, output, session) {

    output$plot <- renderPlot({
      withProgress(message = 'Calculation in progress',
                   detail = 'This may take a while...', value = 0, {
                     for (i in 1:15) {
                       incProgress(1/15)
                       Sys.sleep(0.25)
                     }
                   })
      plot(cars)
    })

  }

  shinyApp(ui, server)
}
}
