% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/freqdom.eigen.R
\name{freqdom.eigen}
\alias{freqdom.eigen}
\title{Eigendecompose a frequency domain operator at each frequency}
\usage{
freqdom.eigen(F)
}
\arguments{
\item{F}{an object of class freqdom. The matrices \code{F\$operator[,,k]} are required to be square matrices, say \eqn{d \times d}.}
}
\value{
Returns a list. The list is containing the following components:
\itemize{
\item \code{vectors} \eqn{\quad} an array containing \eqn{d} matrices. The \eqn{i}-th matrix contains in its \eqn{k}-th row the conjugate transpose eigenvector belonging to the \eqn{k}-th largest eigenvalue of \code{F\$operator[,,i]}.
\item \code{values} \eqn{\quad} matrix containing in \eqn{k}-th column the eigenvalues of \code{F\$operator[,,k]}.
\item \code{freq} \eqn{\quad} vector of frequencies defining the object \code{F}.
}
}
\description{
Gives the eigendecomposition of objects of class \code{freqdom}.
}
\details{
This function makes an eigendecomposition for each of the matrices \code{F\$operator[,,k]}.
}
\seealso{
\code{\link{freqdom}}
}
\keyword{frequency.domain}
