% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_fs_surface.R
\name{write.fs.surface.mz3}
\alias{write.fs.surface.mz3}
\title{Write mesh to file in mz3 binary format.}
\usage{
write.fs.surface.mz3(filepath, vertex_coords, faces, gzipped = TRUE)
}
\arguments{
\item{filepath}{string. Full path to the output surface file, should end with '.mz3', but that is not enforced.}

\item{vertex_coords}{n x 3 matrix of doubles. Each row defined the x,y,z coords for a vertex.}

\item{faces}{n x 3 matrix of integers. Each row defined the 3 vertex indices that make up the face. WARNING: Vertex indices should be given in R-style, i.e., the index of the first vertex is 1. However, they will be written in FreeSurfer style, i.e., all indices will have 1 substracted, so that the index of the first vertex will be zero.}

\item{gzipped}{logical, whether to write a gzip compressed file}
}
\value{
string the format that was written. One of "tris" or "quads". Currently only triangular meshes are supported, so always 'tris'.
}
\description{
Write mesh to file in mz3 binary format.
}
\note{
This format is used by the surf-ice renderer. The format spec is at https://github.com/neurolabusc/surf-ice/tree/master/mz3.
}
\examples{
\dontrun{
    # Read a surface from a file:
    surface_file = system.file("extdata", "lh.tinysurface",
     package = "freesurferformats", mustWork = TRUE);
    mesh = read.fs.surface(surface_file);

    # Now save it:
    write.fs.surface.mz3(tempfile(fileext=".mz3"), mesh$vertices, mesh$faces);
}

}
\seealso{
Other mesh functions: 
\code{\link{faces.quad.to.tris}()},
\code{\link{read.fs.surface.asc}()},
\code{\link{read.fs.surface.bvsrf}()},
\code{\link{read.fs.surface.geo}()},
\code{\link{read.fs.surface.gii}()},
\code{\link{read.fs.surface.ico}()},
\code{\link{read.fs.surface.obj}()},
\code{\link{read.fs.surface.off}()},
\code{\link{read.fs.surface.ply}()},
\code{\link{read.fs.surface.vtk}()},
\code{\link{read.fs.surface}()},
\code{\link{read.mesh.brainvoyager}()},
\code{\link{read_nisurfacefile}()},
\code{\link{read_nisurface}()},
\code{\link{write.fs.surface.asc}()},
\code{\link{write.fs.surface.byu}()},
\code{\link{write.fs.surface.gii}()},
\code{\link{write.fs.surface.vtk}()},
\code{\link{write.fs.surface}()}
}
\concept{mesh functions}
