% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_fs_annot.R
\name{read.fs.annot.gii}
\alias{read.fs.annot.gii}
\title{Read an annotation or label in GIFTI format.}
\usage{
read.fs.annot.gii(
  filepath,
  element_index = 1L,
  labels_only = FALSE,
  rgb_column_names = c("Red", "Green", "Blue", "Alpha"),
  key_column_name = "Key",
  empty_label_name = "unknown"
)
}
\arguments{
\item{filepath}{string. Full path to the input label file in GIFTI format.}

\item{element_index}{positive integer, the index of the dataarray to return. Ignored unless the file contains several dataarrays.}

\item{labels_only}{logical, whether to ignore the colortable and region names. The returned annotation will only contain the a vector that contains one integer label per vertex (as entry 'label_codes'), but no region names and colortable information.}

\item{rgb_column_names}{vector of exactly 4 character strings, order is important. The column names for the red, green, blue and alpha channels in the lable table. If a column does not exist, pass NA. If you do not know the column names, just call the function, it will print them. See 'labels_only' if you do not care.}

\item{key_column_name}{character string, the column name for the key column in the lable table. This is the column that holds the label value from the raw vector (see 'labels_only') that links a label value to a row in the label table. Without it, one cannot recostruct the region name and color of an entry. Passing NA has the same effect as setting 'labels_only' to TRUE.}

\item{empty_label_name}{string. Ignored, deprecated.}
}
\description{
Read an annotation or label in GIFTI format.
}
\seealso{
Other gifti readers: 
\code{\link{read.fs.label.gii}()},
\code{\link{read.fs.morph.gii}()},
\code{\link{read.fs.surface.gii}()}
}
\concept{gifti readers}
